/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.functions;

import java.io.File;
import java.io.FilenameFilter;
import java.util.ArrayList;
import java.util.Optional;
import java.util.StringTokenizer;
import net.sf.saxon.Configuration;
import net.sf.saxon.lib.ParseOptions;
import net.sf.saxon.lib.Validation;
import net.sf.saxon.om.AllElementsSpaceStrippingRule;
import net.sf.saxon.om.IgnorableSpaceStrippingRule;
import net.sf.saxon.om.NoElementsSpaceStrippingRule;
import net.sf.saxon.om.SpaceStrippingRule;
import net.sf.saxon.regex.ARegularExpression;
import net.sf.saxon.regex.JavaRegularExpression;
import net.sf.saxon.regex.RegularExpression;
import net.sf.saxon.str.StringView;
import net.sf.saxon.str.UnicodeBuilder;
import net.sf.saxon.trans.Instantiator;
import net.sf.saxon.trans.Maker;
import net.sf.saxon.trans.XPathException;
import org.xml.sax.XMLReader;

public class URIQueryParameters {
    Optional<FilenameFilter> filter = Optional.empty();
    Optional<Boolean> recurse = Optional.empty();
    Optional<Integer> validation = Optional.empty();
    Optional<SpaceStrippingRule> strippingRule = Optional.empty();
    Optional<Integer> onError = Optional.empty();
    Optional<Boolean> xinclude = Optional.empty();
    Optional<Boolean> stable = Optional.empty();
    Optional<Boolean> metadata = Optional.empty();
    Optional<String> contentType = Optional.empty();
    Optional<Maker<XMLReader>> parserMaker = Optional.empty();
    public static final int ON_ERROR_FAIL = 1;
    public static final int ON_ERROR_WARNING = 2;
    public static final int ON_ERROR_IGNORE = 3;

    public URIQueryParameters(String query, Configuration config) throws XPathException {
        if (query != null) {
            StringTokenizer t = new StringTokenizer(query, ";&");
            while (t.hasMoreTokens()) {
                String tok = t.nextToken();
                int eq = tok.indexOf(61);
                if (eq <= 0 || eq >= tok.length() - 1) continue;
                String keyword = tok.substring(0, eq);
                String value = tok.substring(eq + 1);
                this.processParameter(config, keyword, value);
            }
        }
    }

    private void processParameter(Configuration config, String keyword, String value) throws XPathException {
        if (keyword.equals("select")) {
            this.filter = Optional.of(URIQueryParameters.makeGlobFilter(value));
        } else if (keyword.equals("match")) {
            ARegularExpression regex = new ARegularExpression(StringView.of(value).tidy(), "", "XP", new ArrayList<String>(), config);
            this.filter = Optional.of(new RegexFilter(regex));
        } else if (keyword.equals("recurse")) {
            this.recurse = Optional.of("yes".equals(value));
        } else if (keyword.equals("validation")) {
            int v = Validation.getCode(value);
            if (v != -1) {
                this.validation = Optional.of(v);
            }
        } else if (keyword.equals("strip-space")) {
            switch (value) {
                case "yes": {
                    this.strippingRule = Optional.of(AllElementsSpaceStrippingRule.getInstance());
                    break;
                }
                case "ignorable": {
                    this.strippingRule = Optional.of(IgnorableSpaceStrippingRule.getInstance());
                    break;
                }
                case "no": {
                    this.strippingRule = Optional.of(NoElementsSpaceStrippingRule.getInstance());
                }
            }
        } else if (keyword.equals("stable")) {
            if (value.equals("yes")) {
                this.stable = Optional.of(Boolean.TRUE);
            } else if (value.equals("no")) {
                this.stable = Optional.of(Boolean.FALSE);
            }
        } else if (keyword.equals("metadata")) {
            if (value.equals("yes")) {
                this.metadata = Optional.of(Boolean.TRUE);
            } else if (value.equals("no")) {
                this.metadata = Optional.of(Boolean.FALSE);
            }
        } else if (keyword.equals("xinclude")) {
            if (value.equals("yes")) {
                URIQueryParameters.checkXIncludeIsSupported();
                this.xinclude = Optional.of(Boolean.TRUE);
            } else if (value.equals("no")) {
                this.xinclude = Optional.of(Boolean.FALSE);
            }
        } else if (keyword.equals("content-type")) {
            this.contentType = Optional.of(value);
        } else if (keyword.equals("on-error")) {
            switch (value) {
                case "warning": {
                    this.onError = Optional.of(2);
                    break;
                }
                case "ignore": {
                    this.onError = Optional.of(3);
                    break;
                }
                case "fail": {
                    this.onError = Optional.of(1);
                }
            }
        } else if (keyword.equals("parser") && config != null) {
            this.parserMaker = Optional.of(new Instantiator(value, config));
        }
    }

    private static void checkXIncludeIsSupported() throws XPathException {
    }

    public static FilenameFilter makeGlobFilter(String value) throws XPathException {
        UnicodeBuilder sb = new UnicodeBuilder();
        sb.append('^');
        for (int i = 0; i < value.length(); ++i) {
            char c = value.charAt(i);
            if (c == '.') {
                sb.appendLatin("\\.");
                continue;
            }
            if (c == '*') {
                sb.appendLatin(".*");
                continue;
            }
            if (c == '?') {
                sb.appendLatin(".?");
                continue;
            }
            sb.append(c);
        }
        sb.append('$');
        try {
            return new RegexFilter(new JavaRegularExpression(sb.toUnicodeString(), ""));
        }
        catch (XPathException e) {
            throw new XPathException("Invalid glob " + value + " in collection URI", "FODC0004");
        }
    }

    public Optional<SpaceStrippingRule> getSpaceStrippingRule() {
        return this.strippingRule;
    }

    public Optional<Integer> getValidationMode() {
        return this.validation;
    }

    public Optional<FilenameFilter> getFilenameFilter() {
        return this.filter;
    }

    public Optional<Boolean> getRecurse() {
        return this.recurse;
    }

    public Optional<Integer> getOnError() {
        return this.onError;
    }

    public Optional<Boolean> getXInclude() {
        return this.xinclude;
    }

    public Optional<Boolean> getMetaData() {
        return this.metadata;
    }

    public Optional<String> getContentType() {
        return this.contentType;
    }

    public Optional<Boolean> getStable() {
        return this.stable;
    }

    public Optional<Maker<XMLReader>> getXMLReaderMaker() {
        return this.parserMaker;
    }

    public ParseOptions makeParseOptions(Configuration config) throws XPathException {
        Optional<Boolean> xinclude;
        Optional<Integer> validation;
        ParseOptions options = new ParseOptions();
        Optional<SpaceStrippingRule> stripSpace = this.getSpaceStrippingRule();
        if (stripSpace.isPresent()) {
            options = options.withSpaceStrippingRule(stripSpace.get());
        }
        if ((validation = this.getValidationMode()).isPresent()) {
            options = options.withSchemaValidationMode(validation.get());
        }
        if ((xinclude = this.getXInclude()).isPresent()) {
            options = options.withXIncludeAware(xinclude.get());
        }
        return options;
    }

    public static class RegexFilter
    implements FilenameFilter {
        private final RegularExpression pattern;

        public RegexFilter(RegularExpression regex) {
            this.pattern = regex;
        }

        @Override
        public boolean accept(File dir, String name) {
            return new File(dir, name).isDirectory() || this.pattern.matches(StringView.of(name).tidy());
        }

        public boolean matches(String name) {
            return this.pattern.matches(StringView.of(name).tidy());
        }
    }
}

