/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.infrastructure.jobs.domain;

import jakarta.persistence.LockModeType;
import java.util.List;
import java.util.Optional;
import org.apache.fineract.infrastructure.jobs.data.JobDetailData;
import org.apache.fineract.infrastructure.jobs.domain.ScheduledJobDetail;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.JpaSpecificationExecutor;
import org.springframework.data.jpa.repository.Lock;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;

public interface ScheduledJobDetailRepository
extends JpaRepository<ScheduledJobDetail, Long>,
JpaSpecificationExecutor<ScheduledJobDetail> {
    public static final String GET_DATA = "select new org.apache.fineract.infrastructure.jobs.data.JobDetailData(j.id, j.jobDisplayName, j.shortName, j.nextRunTime, j.errorLog, j.cronExpression, j.activeSchedular, j.currentlyRunning, jh.version, jh.startTime, jh.endTime, jh.status, jh.errorMessage, jh.triggerType, jh.errorLog) from ScheduledJobDetail j left join ScheduledJobRunHistory jh on jh.scheduledJobDetail = j and j.previousRunStartTime = jh.startTime ";

    @Query(value="select jobDetail from ScheduledJobDetail jobDetail where jobDetail.jobKey = :jobKey")
    public ScheduledJobDetail findByJobKey(@Param(value="jobKey") String var1);

    @Query(value="select jobDetail from ScheduledJobDetail jobDetail where jobDetail.id=:jobId")
    public ScheduledJobDetail findByJobId(@Param(value="jobId") Long var1);

    @Lock(value=LockModeType.PESSIMISTIC_WRITE)
    @Query(value="select jobDetail from ScheduledJobDetail jobDetail where jobDetail.jobKey = :jobKey")
    public ScheduledJobDetail findByJobKeyWithLock(@Param(value="jobKey") String var1);

    @Query(value="select jobDetail from ScheduledJobDetail jobDetail where jobDetail.isMismatchedJob = :isMismatchedJob")
    public List<ScheduledJobDetail> findAllMismatchedJobs(@Param(value="isMismatchedJob") boolean var1);

    @Query(value="select jobDetail from ScheduledJobDetail jobDetail where jobDetail.nodeId = :nodeId or jobDetail.nodeId = 0")
    public List<ScheduledJobDetail> findAllJobs(@Param(value="nodeId") Integer var1);

    public ScheduledJobDetail findByJobName(String var1);

    @Query(value="select new org.apache.fineract.infrastructure.jobs.data.JobDetailData(j.id, j.jobDisplayName, j.shortName, j.nextRunTime, j.errorLog, j.cronExpression, j.activeSchedular, j.currentlyRunning, jh.version, jh.startTime, jh.endTime, jh.status, jh.errorMessage, jh.triggerType, jh.errorLog) from ScheduledJobDetail j left join ScheduledJobRunHistory jh on jh.scheduledJobDetail = j and j.previousRunStartTime = jh.startTime where j.id = :jobId")
    public JobDetailData getDataById(@Param(value="jobId") Long var1);

    @Query(value="select new org.apache.fineract.infrastructure.jobs.data.JobDetailData(j.id, j.jobDisplayName, j.shortName, j.nextRunTime, j.errorLog, j.cronExpression, j.activeSchedular, j.currentlyRunning, jh.version, jh.startTime, jh.endTime, jh.status, jh.errorMessage, jh.triggerType, jh.errorLog) from ScheduledJobDetail j left join ScheduledJobRunHistory jh on jh.scheduledJobDetail = j and j.previousRunStartTime = jh.startTime where j.shortName = :shortName")
    public JobDetailData getDataByShortName(@Param(value="shortName") String var1);

    @Query(value="select new org.apache.fineract.infrastructure.jobs.data.JobDetailData(j.id, j.jobDisplayName, j.shortName, j.nextRunTime, j.errorLog, j.cronExpression, j.activeSchedular, j.currentlyRunning, jh.version, jh.startTime, jh.endTime, jh.status, jh.errorMessage, jh.triggerType, jh.errorLog) from ScheduledJobDetail j left join ScheduledJobRunHistory jh on jh.scheduledJobDetail = j and j.previousRunStartTime = jh.startTime order by j.id")
    public List<JobDetailData> getAllData();

    public boolean existsByShortName(String var1);

    @Query(value="select j.id from ScheduledJobDetail j where j.shortName = :shortName")
    public Optional<Long> findIdByShortName(@Param(value="shortName") String var1);
}

