/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.infrastructure.reportmailingjob.api;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.ArraySchema;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.parameters.RequestBody;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.UriInfo;
import lombok.Generated;
import org.apache.fineract.commands.domain.CommandWrapper;
import org.apache.fineract.commands.service.CommandWrapperBuilder;
import org.apache.fineract.commands.service.PortfolioCommandSourceWritePlatformService;
import org.apache.fineract.infrastructure.core.api.ApiRequestParameterHelper;
import org.apache.fineract.infrastructure.core.data.CommandProcessingResult;
import org.apache.fineract.infrastructure.core.serialization.ApiRequestJsonSerializationSettings;
import org.apache.fineract.infrastructure.core.serialization.DefaultToApiJsonSerializer;
import org.apache.fineract.infrastructure.core.service.Page;
import org.apache.fineract.infrastructure.core.service.SearchParameters;
import org.apache.fineract.infrastructure.reportmailingjob.ReportMailingJobConstants;
import org.apache.fineract.infrastructure.reportmailingjob.api.ReportMailingJobApiResourceSwagger;
import org.apache.fineract.infrastructure.reportmailingjob.data.ReportMailingJobData;
import org.apache.fineract.infrastructure.reportmailingjob.service.ReportMailingJobReadPlatformService;
import org.apache.fineract.infrastructure.security.service.PlatformSecurityContext;
import org.apache.fineract.infrastructure.security.service.SqlValidator;
import org.springframework.stereotype.Component;

@Path(value="/v1/reportmailingjobs")
@Component
@Tag(name="Report Mailing Jobs", description="This resource allows you to create a scheduled job that runs a report and sents it by email to specified email addresses.\n\nThe scheduled job can be configured to run once or on a regular basis (once a day, twice a week, etc)")
public class ReportMailingJobApiResource {
    private final PlatformSecurityContext platformSecurityContext;
    private final PortfolioCommandSourceWritePlatformService commandsSourceWritePlatformService;
    private final ApiRequestParameterHelper apiRequestParameterHelper;
    private final DefaultToApiJsonSerializer<ReportMailingJobData> reportMailingToApiJsonSerializer;
    private final ReportMailingJobReadPlatformService reportMailingJobReadPlatformService;
    private final SqlValidator sqlValidator;

    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Operation(summary="Create a Report Mailing Job", description="Mandatory Fields: name, startDateTime, stretchyReportId, emailRecipients, emailSubject, emailMessage, emailAttachmentFileFormatId, recurrence, isActive\n\nOptional Fields: description, stretchyReportParamMap")
    @RequestBody(required=true, content={@Content(schema=@Schema(implementation=ReportMailingJobApiResourceSwagger.PostReportMailingJobsRequest.class))})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK", content={@Content(schema=@Schema(implementation=ReportMailingJobApiResourceSwagger.PostReportMailingJobsResponse.class))})})
    public String createReportMailingJob(@Parameter(hidden=true) String apiRequestBodyAsJson) {
        CommandWrapper commandWrapper = new CommandWrapperBuilder().createReportMailingJob("REPORTMAILINGJOB").withJson(apiRequestBodyAsJson).build();
        CommandProcessingResult commandProcessingResult = this.commandsSourceWritePlatformService.logCommandSource(commandWrapper);
        return this.reportMailingToApiJsonSerializer.serialize((Object)commandProcessingResult);
    }

    @PUT
    @Path(value="{entityId}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Operation(summary="Update a Report Mailing Job\n", description="")
    @RequestBody(required=true, content={@Content(schema=@Schema(implementation=ReportMailingJobApiResourceSwagger.PutReportMailingJobsRequest.class))})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK", content={@Content(schema=@Schema(implementation=ReportMailingJobApiResourceSwagger.PutReportMailingJobsResponse.class))})})
    public String updateReportMailingJob(@PathParam(value="entityId") @Parameter(description="entityId") Long entityId, @Parameter(hidden=true) String apiRequestBodyAsJson) {
        CommandWrapper commandWrapper = new CommandWrapperBuilder().updateReportMailingJob("REPORTMAILINGJOB", entityId).withJson(apiRequestBodyAsJson).build();
        CommandProcessingResult commandProcessingResult = this.commandsSourceWritePlatformService.logCommandSource(commandWrapper);
        return this.reportMailingToApiJsonSerializer.serialize((Object)commandProcessingResult);
    }

    @DELETE
    @Path(value="{entityId}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Operation(summary="Delete a Report Mailing Job", description="")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK", content={@Content(schema=@Schema(implementation=ReportMailingJobApiResourceSwagger.DeleteReportMailingJobsResponse.class))})})
    public String deleteReportMailingJob(@PathParam(value="entityId") @Parameter(description="entityId") Long entityId, @Parameter(hidden=true) String apiRequestBodyAsJson) {
        CommandWrapper commandWrapper = new CommandWrapperBuilder().deleteReportMailingJob("REPORTMAILINGJOB", entityId).withJson(apiRequestBodyAsJson).build();
        CommandProcessingResult commandProcessingResult = this.commandsSourceWritePlatformService.logCommandSource(commandWrapper);
        return this.reportMailingToApiJsonSerializer.serialize((Object)commandProcessingResult);
    }

    @GET
    @Path(value="{entityId}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Operation(summary="Retrieve a Report Mailing Job", description="Example Requests:\n\nreportmailingjobs/1\n\n\nreportmailingjobs/1?template=true")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK", content={@Content(schema=@Schema(implementation=ReportMailingJobApiResourceSwagger.GetReportMailingJobsResponse.class))})})
    public String retrieveReportMailingJob(@PathParam(value="entityId") @Parameter(description="entityId") Long entityId, @Context UriInfo uriInfo) {
        this.platformSecurityContext.authenticatedUser().validateHasReadPermission("REPORTMAILINGJOB");
        ApiRequestJsonSerializationSettings settings = this.apiRequestParameterHelper.process(uriInfo.getQueryParameters());
        ReportMailingJobData reportMailingJobData = this.reportMailingJobReadPlatformService.retrieveReportMailingJob(entityId);
        if (settings.isTemplate()) {
            ReportMailingJobData ReportMailingJobDataOptions = this.reportMailingJobReadPlatformService.retrieveReportMailingJobEnumOptions();
            reportMailingJobData = ReportMailingJobData.newInstance((ReportMailingJobData)reportMailingJobData, (ReportMailingJobData)ReportMailingJobDataOptions);
        }
        return this.reportMailingToApiJsonSerializer.serialize(settings, (Object)reportMailingJobData, ReportMailingJobConstants.REPORT_MAILING_JOB_DATA_PARAMETERS);
    }

    @GET
    @Path(value="template")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Operation(summary="Retrieve Report Mailing Job Details Template", description="This is a convenience resource. It can be useful when building maintenance user interface screens for report mailing job applications. The template data returned consists of any or all of:\n\nField Defaults\nAllowed description Lists\nExample Request:\n\nreportmailingjobs/template")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK", content={@Content(schema=@Schema(implementation=ReportMailingJobApiResourceSwagger.GetReportMailingJobsTemplate.class))})})
    public String retrieveReportMailingJobTemplate(@Context UriInfo uriInfo) {
        this.platformSecurityContext.authenticatedUser().validateHasReadPermission("REPORTMAILINGJOB");
        ApiRequestJsonSerializationSettings settings = this.apiRequestParameterHelper.process(uriInfo.getQueryParameters());
        ReportMailingJobData ReportMailingJobDataOptions = this.reportMailingJobReadPlatformService.retrieveReportMailingJobEnumOptions();
        return this.reportMailingToApiJsonSerializer.serialize(settings, (Object)ReportMailingJobDataOptions, ReportMailingJobConstants.REPORT_MAILING_JOB_DATA_PARAMETERS);
    }

    @GET
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Operation(summary="List Report Mailing Jobs", description="Example Requests:\n\nreportmailingjobs")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK", content={@Content(array=@ArraySchema(schema=@Schema(implementation=ReportMailingJobApiResourceSwagger.GetReportMailingJobsResponse.class)))})})
    public String retrieveAllReportMailingJobs(@Context UriInfo uriInfo, @QueryParam(value="offset") @Parameter(description="offset") Integer offset, @QueryParam(value="limit") @Parameter(description="limit") Integer limit, @QueryParam(value="orderBy") @Parameter(description="orderBy") String orderBy, @QueryParam(value="sortOrder") @Parameter(description="sortOrder") String sortOrder) {
        this.platformSecurityContext.authenticatedUser().validateHasReadPermission("REPORTMAILINGJOB");
        ApiRequestJsonSerializationSettings settings = this.apiRequestParameterHelper.process(uriInfo.getQueryParameters());
        this.sqlValidator.validate(orderBy);
        this.sqlValidator.validate(sortOrder);
        SearchParameters searchParameters = SearchParameters.builder().limit(limit).offset(offset).orderBy(orderBy).sortOrder(sortOrder).build();
        Page reportMailingJobData = this.reportMailingJobReadPlatformService.retrieveAllReportMailingJobs(searchParameters);
        return this.reportMailingToApiJsonSerializer.serialize(settings, reportMailingJobData, ReportMailingJobConstants.REPORT_MAILING_JOB_DATA_PARAMETERS);
    }

    @Generated
    public ReportMailingJobApiResource(PlatformSecurityContext platformSecurityContext, PortfolioCommandSourceWritePlatformService commandsSourceWritePlatformService, ApiRequestParameterHelper apiRequestParameterHelper, DefaultToApiJsonSerializer<ReportMailingJobData> reportMailingToApiJsonSerializer, ReportMailingJobReadPlatformService reportMailingJobReadPlatformService, SqlValidator sqlValidator) {
        this.platformSecurityContext = platformSecurityContext;
        this.commandsSourceWritePlatformService = commandsSourceWritePlatformService;
        this.apiRequestParameterHelper = apiRequestParameterHelper;
        this.reportMailingToApiJsonSerializer = reportMailingToApiJsonSerializer;
        this.reportMailingJobReadPlatformService = reportMailingJobReadPlatformService;
        this.sqlValidator = sqlValidator;
    }
}

