/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.portfolio.client.domain;

import jakarta.persistence.CascadeType;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.FetchType;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.OneToMany;
import jakarta.persistence.Table;
import jakarta.persistence.Transient;
import jakarta.persistence.UniqueConstraint;
import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.apache.fineract.accounting.glaccount.domain.GLAccount;
import org.apache.fineract.infrastructure.core.data.EnumOptionData;
import org.apache.fineract.infrastructure.core.domain.AbstractAuditableWithUTCDateTimeCustom;
import org.apache.fineract.infrastructure.core.domain.ExternalId;
import org.apache.fineract.infrastructure.core.service.DateUtils;
import org.apache.fineract.organisation.monetary.domain.MonetaryCurrency;
import org.apache.fineract.organisation.monetary.domain.Money;
import org.apache.fineract.organisation.monetary.domain.OrganisationCurrency;
import org.apache.fineract.organisation.office.domain.Office;
import org.apache.fineract.portfolio.client.domain.Client;
import org.apache.fineract.portfolio.client.domain.ClientChargePaidBy;
import org.apache.fineract.portfolio.client.domain.ClientEnumerations;
import org.apache.fineract.portfolio.client.domain.ClientTransactionType;
import org.apache.fineract.portfolio.paymentdetail.domain.PaymentDetail;
import org.eclipse.persistence.internal.descriptors.PersistenceObject;
import org.eclipse.persistence.internal.weaving.PersistenceWeaved;
import org.eclipse.persistence.internal.weaving.PersistenceWeavedFetchGroups;

@Entity
@Table(name="m_client_transaction", uniqueConstraints={@UniqueConstraint(columnNames={"external_id"}, name="external_id")})
public class ClientTransaction
extends AbstractAuditableWithUTCDateTimeCustom<Long>
implements PersistenceWeaved,
PersistenceObject,
PersistenceWeavedFetchGroups {
    @ManyToOne(optional=false)
    @JoinColumn(name="client_id", nullable=false)
    private Client client;
    @ManyToOne
    @JoinColumn(name="office_id", nullable=false)
    private Office office;
    @ManyToOne(optional=true)
    @JoinColumn(name="payment_detail_id", nullable=true)
    private PaymentDetail paymentDetail;
    @Column(name="currency_code", length=3)
    private String currencyCode;
    @Column(name="transaction_type_enum", nullable=false)
    private Integer typeOf;
    @Column(name="transaction_date", nullable=false)
    private LocalDate dateOf;
    @Column(name="submitted_on_date", nullable=false)
    private LocalDate submittedOnDate;
    @Column(name="amount", scale=6, precision=19, nullable=false)
    private BigDecimal amount;
    @Column(name="is_reversed", nullable=false)
    private boolean reversed;
    @Column(name="external_id", length=100, nullable=true, unique=true)
    private ExternalId externalId;
    @OneToMany(cascade={CascadeType.ALL}, mappedBy="clientTransaction", orphanRemoval=true, fetch=FetchType.EAGER)
    private Set<ClientChargePaidBy> clientChargePaidByCollection = new HashSet();
    @Transient
    private OrganisationCurrency currency;
    static final long serialVersionUID = -5646436018052659693L;

    protected ClientTransaction() {
    }

    public static ClientTransaction payCharge(Client client, Office office, PaymentDetail paymentDetail, LocalDate transactionDate, Money amount, String currencyCode, ExternalId externalId) {
        boolean isReversed = false;
        return new ClientTransaction(client, office, paymentDetail, ClientTransactionType.PAY_CHARGE.getValue(), transactionDate, amount, false, externalId, currencyCode);
    }

    public static ClientTransaction waiver(Client client, Office office, LocalDate transactionDate, Money amount, String currencyCode) {
        boolean isReversed = false;
        ExternalId externalId = ExternalId.empty();
        PaymentDetail paymentDetail = null;
        return new ClientTransaction(client, office, paymentDetail, ClientTransactionType.WAIVE_CHARGE.getValue(), transactionDate, amount, false, externalId, currencyCode);
    }

    public ClientTransaction(Client client, Office office, PaymentDetail paymentDetail, Integer typeOf, LocalDate transactionDate, Money amount, boolean reversed, ExternalId externalId, String currencyCode) {
        this.client = client;
        this.office = office;
        this.paymentDetail = paymentDetail;
        this.typeOf = typeOf;
        this.dateOf = transactionDate;
        this.amount = amount.getAmount();
        this.reversed = reversed;
        this.externalId = externalId;
        this.currencyCode = currencyCode;
        this.submittedOnDate = DateUtils.getBusinessLocalDate();
    }

    public void reverse() {
        this._persistence_set_reversed(true);
    }

    public Map<String, Object> toMapData() {
        LinkedHashMap<String, Object> thisTransactionData = new LinkedHashMap<String, Object>();
        EnumOptionData transactionType = ClientEnumerations.clientTransactionType((int)this._persistence_get_typeOf());
        Boolean accountingEnabledForAtleastOneCharge = false;
        thisTransactionData.put("id", this.getId());
        thisTransactionData.put("clientId", this.getClientId());
        thisTransactionData.put("officeId", this._persistence_get_office().getId());
        thisTransactionData.put("type", transactionType);
        thisTransactionData.put("reversed", this._persistence_get_reversed());
        thisTransactionData.put("date", this.getTransactionDate());
        thisTransactionData.put("currencyCode", this._persistence_get_currencyCode());
        thisTransactionData.put("amount", this._persistence_get_amount());
        if (this._persistence_get_paymentDetail() != null) {
            thisTransactionData.put("paymentTypeId", this._persistence_get_paymentDetail().getPaymentType().getId());
        }
        if (!this._persistence_get_clientChargePaidByCollection().isEmpty()) {
            ArrayList clientChargesPaidData = new ArrayList();
            for (ClientChargePaidBy clientChargePaidBy : this._persistence_get_clientChargePaidByCollection()) {
                LinkedHashMap<String, Serializable> clientChargePaidData = new LinkedHashMap<String, Serializable>();
                clientChargePaidData.put("chargeId", clientChargePaidBy.getClientCharge().getCharge().getId());
                clientChargePaidData.put("isPenalty", Boolean.valueOf(clientChargePaidBy.getClientCharge().getCharge().isPenalty()));
                clientChargePaidData.put("clientChargeId", clientChargePaidBy.getClientCharge().getId());
                clientChargePaidData.put("amount", clientChargePaidBy.getAmount());
                GLAccount glAccount = clientChargePaidBy.getClientCharge().getCharge().getAccount();
                if (glAccount != null) {
                    accountingEnabledForAtleastOneCharge = true;
                    clientChargePaidData.put("incomeAccountId", glAccount.getId());
                }
                clientChargesPaidData.add(clientChargePaidData);
            }
            thisTransactionData.put("clientChargesPaid", clientChargesPaidData);
        }
        thisTransactionData.put("accountingEnabled", accountingEnabledForAtleastOneCharge);
        return thisTransactionData;
    }

    public boolean isPayChargeTransaction() {
        return ClientTransactionType.PAY_CHARGE.getValue().equals(this._persistence_get_typeOf());
    }

    public boolean isWaiveChargeTransaction() {
        return ClientTransactionType.WAIVE_CHARGE.getValue().equals(this._persistence_get_typeOf());
    }

    public Set<ClientChargePaidBy> getClientChargePaidByCollection() {
        return this._persistence_get_clientChargePaidByCollection();
    }

    public Long getClientId() {
        return (Long)this._persistence_get_client().getId();
    }

    public Client getClient() {
        return this._persistence_get_client();
    }

    public Money getAmount() {
        return Money.of((MonetaryCurrency)this.getCurrency(), (BigDecimal)this._persistence_get_amount());
    }

    public MonetaryCurrency getCurrency() {
        return this.currency.toMonetaryCurrency();
    }

    public void setCurrency(OrganisationCurrency currency) {
        this.currency = currency;
    }

    public String getCurrencyCode() {
        return this._persistence_get_currencyCode();
    }

    public boolean isReversed() {
        return this._persistence_get_reversed();
    }

    public LocalDate getTransactionDate() {
        return this._persistence_get_dateOf();
    }

    public LocalDate getSubmittedOnDate() {
        return this._persistence_get_submittedOnDate();
    }

    public ExternalId getExternalId() {
        return this._persistence_get_externalId();
    }

    public Object _persistence_post_clone() {
        Object object = super._persistence_post_clone();
        this._persistence_fetchGroup = null;
        this._persistence_session = null;
        this._persistence_primaryKey = null;
        return this;
    }

    public Object _persistence_new(PersistenceObject persistenceObject) {
        return new ClientTransaction();
    }

    public Object _persistence_get(String string) {
        if (string == "amount") {
            return this.amount;
        }
        if (string == "externalId") {
            return this.externalId;
        }
        if (string == "office") {
            return this.office;
        }
        if (string == "dateOf") {
            return this.dateOf;
        }
        if (string == "paymentDetail") {
            return this.paymentDetail;
        }
        if (string == "clientChargePaidByCollection") {
            return this.clientChargePaidByCollection;
        }
        if (string == "client") {
            return this.client;
        }
        if (string == "submittedOnDate") {
            return this.submittedOnDate;
        }
        if (string == "currencyCode") {
            return this.currencyCode;
        }
        if (string == "typeOf") {
            return this.typeOf;
        }
        if (string == "reversed") {
            return this.reversed;
        }
        return super._persistence_get(string);
    }

    public void _persistence_set(String string, Object object) {
        if (string == "amount") {
            this.amount = (BigDecimal)object;
            return;
        }
        if (string == "externalId") {
            this.externalId = (ExternalId)object;
            return;
        }
        if (string == "office") {
            this.office = (Office)object;
            return;
        }
        if (string == "dateOf") {
            this.dateOf = (LocalDate)object;
            return;
        }
        if (string == "paymentDetail") {
            this.paymentDetail = (PaymentDetail)object;
            return;
        }
        if (string == "clientChargePaidByCollection") {
            this.clientChargePaidByCollection = (Set)object;
            return;
        }
        if (string == "client") {
            this.client = (Client)object;
            return;
        }
        if (string == "submittedOnDate") {
            this.submittedOnDate = (LocalDate)object;
            return;
        }
        if (string == "currencyCode") {
            this.currencyCode = (String)object;
            return;
        }
        if (string == "typeOf") {
            this.typeOf = (Integer)object;
            return;
        }
        if (string == "reversed") {
            this.reversed = (Boolean)object;
            return;
        }
        super._persistence_set(string, object);
    }

    public BigDecimal _persistence_get_amount() {
        this._persistence_checkFetched("amount");
        return this.amount;
    }

    public void _persistence_set_amount(BigDecimal bigDecimal) {
        this._persistence_checkFetchedForSet("amount");
        this.amount = bigDecimal;
    }

    public ExternalId _persistence_get_externalId() {
        this._persistence_checkFetched("externalId");
        return this.externalId;
    }

    public void _persistence_set_externalId(ExternalId externalId) {
        this._persistence_checkFetchedForSet("externalId");
        this.externalId = externalId;
    }

    public Office _persistence_get_office() {
        this._persistence_checkFetched("office");
        return this.office;
    }

    public void _persistence_set_office(Office office) {
        this._persistence_checkFetchedForSet("office");
        this.office = office;
    }

    public LocalDate _persistence_get_dateOf() {
        this._persistence_checkFetched("dateOf");
        return this.dateOf;
    }

    public void _persistence_set_dateOf(LocalDate localDate) {
        this._persistence_checkFetchedForSet("dateOf");
        this.dateOf = localDate;
    }

    public PaymentDetail _persistence_get_paymentDetail() {
        this._persistence_checkFetched("paymentDetail");
        return this.paymentDetail;
    }

    public void _persistence_set_paymentDetail(PaymentDetail paymentDetail) {
        this._persistence_checkFetchedForSet("paymentDetail");
        this.paymentDetail = paymentDetail;
    }

    public Set _persistence_get_clientChargePaidByCollection() {
        this._persistence_checkFetched("clientChargePaidByCollection");
        return this.clientChargePaidByCollection;
    }

    public void _persistence_set_clientChargePaidByCollection(Set set) {
        this._persistence_checkFetchedForSet("clientChargePaidByCollection");
        this.clientChargePaidByCollection = set;
    }

    public Client _persistence_get_client() {
        this._persistence_checkFetched("client");
        return this.client;
    }

    public void _persistence_set_client(Client client) {
        this._persistence_checkFetchedForSet("client");
        this.client = client;
    }

    public LocalDate _persistence_get_submittedOnDate() {
        this._persistence_checkFetched("submittedOnDate");
        return this.submittedOnDate;
    }

    public void _persistence_set_submittedOnDate(LocalDate localDate) {
        this._persistence_checkFetchedForSet("submittedOnDate");
        this.submittedOnDate = localDate;
    }

    public String _persistence_get_currencyCode() {
        this._persistence_checkFetched("currencyCode");
        return this.currencyCode;
    }

    public void _persistence_set_currencyCode(String string) {
        this._persistence_checkFetchedForSet("currencyCode");
        this.currencyCode = string;
    }

    public Integer _persistence_get_typeOf() {
        this._persistence_checkFetched("typeOf");
        return this.typeOf;
    }

    public void _persistence_set_typeOf(Integer n) {
        this._persistence_checkFetchedForSet("typeOf");
        this.typeOf = n;
    }

    public boolean _persistence_get_reversed() {
        this._persistence_checkFetched("reversed");
        return this.reversed;
    }

    public void _persistence_set_reversed(boolean bl) {
        this._persistence_checkFetchedForSet("reversed");
        this.reversed = bl;
    }
}

