/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.portfolio.products.api;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.parameters.RequestBody;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.UriInfo;
import lombok.Generated;
import org.apache.fineract.commands.domain.CommandWrapper;
import org.apache.fineract.commands.service.CommandWrapperBuilder;
import org.apache.fineract.commands.service.PortfolioCommandSourceWritePlatformService;
import org.apache.fineract.infrastructure.core.api.ApiRequestParameterHelper;
import org.apache.fineract.infrastructure.core.data.CommandProcessingResult;
import org.apache.fineract.infrastructure.core.exception.ResourceNotFoundException;
import org.apache.fineract.infrastructure.core.serialization.ApiRequestJsonSerializationSettings;
import org.apache.fineract.infrastructure.core.serialization.DefaultToApiJsonSerializer;
import org.apache.fineract.infrastructure.core.service.Page;
import org.apache.fineract.infrastructure.security.service.PlatformSecurityContext;
import org.apache.fineract.portfolio.products.api.ProductsApiResourceSwagger;
import org.apache.fineract.portfolio.products.data.ProductData;
import org.apache.fineract.portfolio.products.service.ShareProductReadPlatformService;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.stereotype.Component;

@Path(value="/v1/products/{type}")
@Component
@Tag(name="Products", description="")
public class ProductsApiResource {
    private final ApplicationContext applicationContext;
    private final ApiRequestParameterHelper apiRequestParameterHelper;
    private final DefaultToApiJsonSerializer<ProductData> toApiJsonSerializer;
    private final PlatformSecurityContext platformSecurityContext;
    private final PortfolioCommandSourceWritePlatformService commandsSourceWritePlatformService;

    @GET
    @Path(value="template")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public String retrieveTemplate(@PathParam(value="type") @Parameter(description="type") String productType, @Context UriInfo uriInfo) {
        String serviceName = productType + "ReadPlatformService";
        try {
            ShareProductReadPlatformService service = (ShareProductReadPlatformService)this.applicationContext.getBean(serviceName);
            ProductData data = service.retrieveTemplate();
            ApiRequestJsonSerializationSettings settings = this.apiRequestParameterHelper.process(uriInfo.getQueryParameters());
            return this.toApiJsonSerializer.serialize(settings, (Object)data, service.getResponseDataParams());
        }
        catch (BeansException e) {
            throw new ResourceNotFoundException(e);
        }
    }

    @GET
    @Path(value="{productId}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Operation(summary="Retrieve a Share Product", description="Retrieves a Share Product\n\nExample Requests:\n\nproducts/share/1\n\n\nproducts/share/1?template=true")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK", content={@Content(schema=@Schema(implementation=ProductsApiResourceSwagger.GetProductsTypeProductIdResponse.class))})})
    public String retrieveProduct(@PathParam(value="productId") @Parameter(description="productId") Long productId, @PathParam(value="type") @Parameter(description="type") String productType, @Context UriInfo uriInfo) {
        try {
            String serviceName = productType + "ReadPlatformService";
            ShareProductReadPlatformService service = (ShareProductReadPlatformService)this.applicationContext.getBean(serviceName);
            ApiRequestJsonSerializationSettings settings = this.apiRequestParameterHelper.process(uriInfo.getQueryParameters());
            ProductData data = service.retrieveOne(productId, settings.isTemplate());
            return this.toApiJsonSerializer.serialize(settings, (Object)data, service.getResponseDataParams());
        }
        catch (BeansException e) {
            throw new ResourceNotFoundException(e);
        }
    }

    @GET
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Operation(summary="List Share Products", description="Lists Share Products\n\nMandatory Fields: limit, offset\n\nExample Requests:\n\nshareproducts")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK", content={@Content(schema=@Schema(implementation=ProductsApiResourceSwagger.GetProductsTypeResponse.class))})})
    public String retrieveAllProducts(@PathParam(value="type") @Parameter(description="type") String productType, @QueryParam(value="offset") @Parameter(description="offset") Integer offset, @QueryParam(value="limit") @Parameter(description="limit") Integer limit, @Context UriInfo uriInfo) {
        try {
            String serviceName = productType + "ReadPlatformService";
            ShareProductReadPlatformService service = (ShareProductReadPlatformService)this.applicationContext.getBean(serviceName);
            Page data = service.retrieveAllProducts(offset, limit);
            ApiRequestJsonSerializationSettings settings = this.apiRequestParameterHelper.process(uriInfo.getQueryParameters());
            return this.toApiJsonSerializer.serialize(settings, data, service.getResponseDataParams());
        }
        catch (BeansException e) {
            throw new ResourceNotFoundException(e);
        }
    }

    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Operation(summary="Create a Share Product", description="Creates a Share Product\n\nMandatory Fields: name, shortName, description, currencyCode, digitsAfterDecimal,inMultiplesOf, locale, totalShares, unitPrice, nominalShares,allowDividendCalculationForInactiveClients,accountingRule\n\nMandatory Fields for Cash based accounting (accountingRule = 2): shareReferenceId, shareSuspenseId, shareEquityId, incomeFromFeeAccountId\n\nOptional Fields: sharesIssued, minimumShares, maximumShares, minimumActivePeriodForDividends, minimumactiveperiodFrequencyType, lockinPeriodFrequency, lockinPeriodFrequencyType, marketPricePeriods, chargesSelected")
    @RequestBody(required=true, content={@Content(schema=@Schema(implementation=ProductsApiResourceSwagger.PostProductsTypeRequest.class))})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK", content={@Content(schema=@Schema(implementation=ProductsApiResourceSwagger.PostProductsTypeResponse.class))})})
    public String createProduct(@PathParam(value="type") @Parameter(description="type") String productType, @Parameter(hidden=true) String apiRequestBodyAsJson) {
        CommandWrapper commandWrapper = null;
        this.platformSecurityContext.authenticatedUser();
        commandWrapper = new CommandWrapperBuilder().createProduct(productType).withJson(apiRequestBodyAsJson).build();
        CommandProcessingResult commandProcessingResult = this.commandsSourceWritePlatformService.logCommandSource(commandWrapper);
        return this.toApiJsonSerializer.serialize((Object)commandProcessingResult);
    }

    @POST
    @Path(value="{productId}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public String handleCommands(@PathParam(value="type") @Parameter(description="type") String productType, @PathParam(value="productId") @Parameter(description="productId") Long productId, @QueryParam(value="command") @Parameter(description="command") String commandParam, @Context UriInfo uriInfo, @Parameter(hidden=true) String apiRequestBodyAsJson) {
        CommandWrapper commandWrapper = new CommandWrapperBuilder().createProductCommand(productType, commandParam, productId).withJson(apiRequestBodyAsJson).build();
        CommandProcessingResult commandProcessingResult = this.commandsSourceWritePlatformService.logCommandSource(commandWrapper);
        return this.toApiJsonSerializer.serialize((Object)commandProcessingResult);
    }

    @PUT
    @Path(value="{productId}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Operation(summary="Update a Share Product", description="Updates a Share Product")
    @RequestBody(required=true, content={@Content(schema=@Schema(implementation=ProductsApiResourceSwagger.PutProductsTypeProductIdRequest.class))})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK", content={@Content(schema=@Schema(implementation=ProductsApiResourceSwagger.PutProductsTypeProductIdResponse.class))})})
    public String updateProduct(@PathParam(value="type") @Parameter(description="type") String productType, @PathParam(value="productId") @Parameter(description="productId") Long productId, @Parameter(hidden=true) String apiRequestBodyAsJson) {
        this.platformSecurityContext.authenticatedUser();
        CommandWrapper commandRequest = new CommandWrapperBuilder().updateProduct(productType, productId).withJson(apiRequestBodyAsJson).build();
        CommandProcessingResult result = this.commandsSourceWritePlatformService.logCommandSource(commandRequest);
        return this.toApiJsonSerializer.serialize((Object)result);
    }

    @Generated
    public ProductsApiResource(ApplicationContext applicationContext, ApiRequestParameterHelper apiRequestParameterHelper, DefaultToApiJsonSerializer<ProductData> toApiJsonSerializer, PlatformSecurityContext platformSecurityContext, PortfolioCommandSourceWritePlatformService commandsSourceWritePlatformService) {
        this.applicationContext = applicationContext;
        this.apiRequestParameterHelper = apiRequestParameterHelper;
        this.toApiJsonSerializer = toApiJsonSerializer;
        this.platformSecurityContext = platformSecurityContext;
        this.commandsSourceWritePlatformService = commandsSourceWritePlatformService;
    }
}

