/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.client.models;

import com.google.gson.annotations.SerializedName;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;

public class MediaType {
    public static final String SERIALIZED_NAME_PARAMETERS = "parameters";
    @SerializedName(value="parameters")
    private Map<String, String> parameters;
    public static final String SERIALIZED_NAME_SUBTYPE = "subtype";
    @SerializedName(value="subtype")
    private String subtype;
    public static final String SERIALIZED_NAME_TYPE = "type";
    @SerializedName(value="type")
    private String type;
    public static final String SERIALIZED_NAME_WILDCARD_SUBTYPE = "wildcardSubtype";
    @SerializedName(value="wildcardSubtype")
    private Boolean wildcardSubtype;
    public static final String SERIALIZED_NAME_WILDCARD_TYPE = "wildcardType";
    @SerializedName(value="wildcardType")
    private Boolean wildcardType;

    public MediaType parameters(Map<String, String> parameters) {
        this.parameters = parameters;
        return this;
    }

    public MediaType putParametersItem(String key, String parametersItem) {
        if (this.parameters == null) {
            this.parameters = new HashMap<String, String>();
        }
        this.parameters.put(key, parametersItem);
        return this;
    }

    @Nullable
    public Map<String, String> getParameters() {
        return this.parameters;
    }

    public void setParameters(Map<String, String> parameters) {
        this.parameters = parameters;
    }

    public MediaType subtype(String subtype) {
        this.subtype = subtype;
        return this;
    }

    @Nullable
    public String getSubtype() {
        return this.subtype;
    }

    public void setSubtype(String subtype) {
        this.subtype = subtype;
    }

    public MediaType type(String type) {
        this.type = type;
        return this;
    }

    @Nullable
    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public MediaType wildcardSubtype(Boolean wildcardSubtype) {
        this.wildcardSubtype = wildcardSubtype;
        return this;
    }

    @Nullable
    public Boolean getWildcardSubtype() {
        return this.wildcardSubtype;
    }

    public void setWildcardSubtype(Boolean wildcardSubtype) {
        this.wildcardSubtype = wildcardSubtype;
    }

    public MediaType wildcardType(Boolean wildcardType) {
        this.wildcardType = wildcardType;
        return this;
    }

    @Nullable
    public Boolean getWildcardType() {
        return this.wildcardType;
    }

    public void setWildcardType(Boolean wildcardType) {
        this.wildcardType = wildcardType;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MediaType mediaType = (MediaType)o;
        return Objects.equals(this.parameters, mediaType.parameters) && Objects.equals(this.subtype, mediaType.subtype) && Objects.equals(this.type, mediaType.type) && Objects.equals(this.wildcardSubtype, mediaType.wildcardSubtype) && Objects.equals(this.wildcardType, mediaType.wildcardType);
    }

    public int hashCode() {
        return Objects.hash(this.parameters, this.subtype, this.type, this.wildcardSubtype, this.wildcardType);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class MediaType {\n");
        sb.append("    parameters: ").append(this.toIndentedString(this.parameters)).append("\n");
        sb.append("    subtype: ").append(this.toIndentedString(this.subtype)).append("\n");
        sb.append("    type: ").append(this.toIndentedString(this.type)).append("\n");
        sb.append("    wildcardSubtype: ").append(this.toIndentedString(this.wildcardSubtype)).append("\n");
        sb.append("    wildcardType: ").append(this.toIndentedString(this.wildcardType)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

