/*
 * Decompiled with CFR 0.152.
 */
package grails.io;

import grails.util.BuildSettings;
import groovy.lang.Closure;
import groovy.lang.GroovyObject;
import groovy.lang.MetaClass;
import groovy.transform.Generated;
import groovy.transform.Internal;
import java.beans.Transient;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileFilter;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.ref.SoftReference;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.BytecodeInterface8;
import org.codehaus.groovy.runtime.DefaultGroovyMethods;
import org.codehaus.groovy.runtime.GStringImpl;
import org.codehaus.groovy.runtime.GeneratedClosure;
import org.codehaus.groovy.runtime.ResourceGroovyMethods;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.runtime.StringGroovyMethods;
import org.codehaus.groovy.runtime.callsite.CallSite;
import org.codehaus.groovy.runtime.callsite.CallSiteArray;
import org.codehaus.groovy.runtime.typehandling.DefaultTypeTransformation;
import org.codehaus.groovy.runtime.typehandling.ShortTypeHandling;
import org.grails.io.support.Resource;
import org.grails.io.support.SpringIOUtils;
import org.grails.io.support.UrlResource;

public class IOUtils
extends SpringIOUtils
implements GroovyObject {
    public static final String RESOURCE_JAR_PREFIX = ".jar!";
    public static final String RESOURCE_WAR_PREFIX = ".war!";
    private static String applicationDirectory;
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;
    private transient /* synthetic */ MetaClass metaClass;
    private static final Closure memoizedMethodClosure$findApplicationDirectoryFile;
    private static final Closure memoizedMethodClosure$findSourceFileString;
    private static final Closure memoizedMethodClosure$findApplicationDirectory;
    private static /* synthetic */ ClassInfo $staticClassInfo$;
    private static /* synthetic */ SoftReference $callSiteArray;

    @Generated
    public IOUtils() {
        MetaClass metaClass;
        this.metaClass = metaClass = this.$getStaticMetaClass();
    }

    public static BufferedInputStream openStream(File file) {
        if (!file.exists()) {
            throw (Throwable)new FileNotFoundException(ShortTypeHandling.castToString(new GStringImpl(new Object[]{file}, new String[]{"File ", " does not exist"})));
        }
        if (file.isDirectory()) {
            throw (Throwable)new IOException(ShortTypeHandling.castToString(new GStringImpl(new Object[]{file}, new String[]{"File ", " exists but is a directory"})));
        }
        if (!file.canRead()) {
            throw (Throwable)new IOException(ShortTypeHandling.castToString(new GStringImpl(new Object[]{file}, new String[]{"File ", " cannot be read"})));
        }
        return ResourceGroovyMethods.newInputStream(file);
    }

    public static String toString(Reader reader) {
        StringWriter writer = new StringWriter();
        SpringIOUtils.copy(reader, (Writer)writer);
        return writer.toString();
    }

    public static String toString(InputStream stream, String encoding) {
        StringWriter writer = new StringWriter();
        IOUtils.copy(stream, writer, encoding);
        return writer.toString();
    }

    public static void copy(InputStream input, Writer output, String encoding) {
        InputStreamReader reader = DefaultTypeTransformation.booleanUnbox(encoding) ? new InputStreamReader(input, encoding) : new InputStreamReader(input);
        SpringIOUtils.copy(reader, output);
    }

    public static File findJarFile(Class targetClass) {
        URL resource = IOUtils.findClassResource(targetClass);
        return IOUtils.findJarFile(resource);
    }

    public static boolean isWithinBinary(URL url) {
        String protocol = url.getProtocol();
        return protocol == null || ScriptBytecodeAdapter.compareNotEqual(protocol, "file");
    }

    public static File findJarFile(Resource resource) {
        Resource resource2 = resource;
        String absolutePath = resource2 != null ? resource2.getFilename() : null;
        if (DefaultTypeTransformation.booleanUnbox(absolutePath)) {
            String jarPath = absolutePath.substring("file:".length(), absolutePath.lastIndexOf("!"));
            new File(jarPath);
        }
        return (File)ScriptBytecodeAdapter.castToType(null, File.class);
    }

    public static File findJarFile(URL resource) {
        URL uRL = resource;
        if (ScriptBytecodeAdapter.compareEqual(uRL != null ? uRL.getProtocol() : null, "jar")) {
            URL uRL2 = resource;
            String absolutePath = uRL2 != null ? uRL2.getPath() : null;
            if (DefaultTypeTransformation.booleanUnbox(absolutePath)) {
                File file = Paths.get(new URL(absolutePath.substring(0, absolutePath.lastIndexOf("!"))).toURI()).toFile();
                try {
                    return file;
                }
                catch (MalformedURLException e) {
                    File file2 = (File)ScriptBytecodeAdapter.castToType(null, File.class);
                    return file2;
                }
            }
        }
        return (File)ScriptBytecodeAdapter.castToType(null, File.class);
    }

    public static URL findClassResource(Class targetClass) {
        return targetClass.getResource(StringGroovyMethods.plus(StringGroovyMethods.plus("/", (CharSequence)targetClass.getName().replace(".", "/")), (CharSequence)".class"));
    }

    public static URL findRootResource(Class targetClass) {
        String pathToClassFile = StringGroovyMethods.plus(StringGroovyMethods.plus("/", (CharSequence)targetClass.getName().replace(".", "/")), (CharSequence)".class");
        URL classRes = targetClass.getResource(pathToClassFile);
        if (classRes != null) {
            String rootPath = StringGroovyMethods.minus((CharSequence)classRes.toString(), pathToClassFile);
            return new URL(ShortTypeHandling.castToString(new GStringImpl(new Object[]{rootPath}, new String[]{"", "/"})));
        }
        throw (Throwable)new IllegalStateException("Root classpath resource not found! Check your disk permissions");
    }

    public static URL findRootResourcesURL(Class targetClass) {
        String pathToClassFile = StringGroovyMethods.plus(StringGroovyMethods.plus("/", (CharSequence)targetClass.getName().replace(".", "/")), (CharSequence)".class");
        URL classRes = targetClass.getResource(pathToClassFile);
        if (classRes != null) {
            String rootPath = StringGroovyMethods.minus((CharSequence)classRes.toString(), pathToClassFile);
            rootPath = rootPath.endsWith(BuildSettings.BUILD_CLASSES_PATH) ? rootPath.replace("/build/classes/groovy/", "/build/resources/") : ShortTypeHandling.castToString(new GStringImpl(new Object[]{rootPath}, new String[]{"", "/"}));
            return new URL(rootPath);
        }
        return (URL)ScriptBytecodeAdapter.castToType(null, URL.class);
    }

    public static URL findJarResource(Class targetClass) {
        URL classUrl = IOUtils.findClassResource(targetClass);
        if (classUrl != null) {
            String urlPath = classUrl.toString();
            int bang = urlPath.lastIndexOf("!");
            if (bang > -1) {
                String newPath = urlPath.substring(0, bang);
                return new URL(ShortTypeHandling.castToString(new GStringImpl(new Object[]{newPath}, new String[]{"", "!/"})));
            }
        }
        return (URL)ScriptBytecodeAdapter.castToType(null, URL.class);
    }

    public static URL findResourceRelativeToClass(Class targetClass, String path) {
        String pathToClassFile = StringGroovyMethods.plus(StringGroovyMethods.plus("/", (CharSequence)targetClass.getName().replace(".", "/")), (CharSequence)".class");
        URL classRes = targetClass.getResource(pathToClassFile);
        if (classRes != null) {
            String rootPath = StringGroovyMethods.minus((CharSequence)classRes.toString(), pathToClassFile);
            if (rootPath.endsWith(BuildSettings.BUILD_CLASSES_PATH)) {
                rootPath = rootPath.replace("/build/classes/groovy/", "/build/resources/");
            }
            return new URL(ShortTypeHandling.castToString(new GStringImpl(new Object[]{rootPath, path}, new String[]{"", "", ""})));
        }
        return (URL)ScriptBytecodeAdapter.castToType(null, URL.class);
    }

    public static File findApplicationDirectoryFile() {
        return (File)ScriptBytecodeAdapter.castToType(memoizedMethodClosure$findApplicationDirectoryFile.call(), File.class);
    }

    public static File findApplicationDirectoryFile(Class targetClass) {
        block10: {
            URL rootResource = IOUtils.findRootResource(targetClass);
            if (rootResource != null) {
                File rootFile;
                block9: {
                    rootFile = new UrlResource(rootResource).getFile().getCanonicalFile();
                    String rootPath = rootFile.getPath();
                    String buildClassespath = BuildSettings.BUILD_CLASSES_PATH.replace("/", File.separator);
                    if (!rootPath.contains(buildClassespath)) break block9;
                    File file = new File(StringGroovyMethods.minus((CharSequence)rootPath, buildClassespath));
                    return file;
                }
                File appDir = IOUtils.findGrailsApp(rootFile);
                if (!(appDir != null)) break block10;
                File file = appDir;
                try {
                    return file;
                }
                catch (FileNotFoundException fnfe) {
                    File file2 = (File)ScriptBytecodeAdapter.castToType(null, File.class);
                    return file2;
                }
            }
        }
        return (File)ScriptBytecodeAdapter.castToType(null, File.class);
    }

    public static File findSourceFile(String className) {
        return (File)ScriptBytecodeAdapter.castToType(memoizedMethodClosure$findSourceFileString.call((Object)className), File.class);
    }

    public static String findApplicationDirectory() {
        return ShortTypeHandling.castToString(memoizedMethodClosure$findApplicationDirectory.call());
    }

    private static File findGrailsApp(File file) {
        File parent = file.getParentFile();
        while (parent != null) {
            File grailsApp = new File(parent, "grails-app");
            if (grailsApp.isDirectory()) {
                return parent;
            }
            parent.getParentFile();
        }
        return (File)ScriptBytecodeAdapter.castToType(null, File.class);
    }

    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (this.getClass() != IOUtils.class) {
            return ScriptBytecodeAdapter.initMetaClass(this);
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
        }
        return classInfo.getMetaClass();
    }

    @Generated
    private static File memoizedMethodPriv$findApplicationDirectoryFile() {
        String directory = IOUtils.findApplicationDirectory();
        if (DefaultTypeTransformation.booleanUnbox(directory)) {
            File f = new File(directory);
            if (f.exists()) {
                return f;
            }
        }
        return (File)ScriptBytecodeAdapter.castToType(null, File.class);
    }

    @Generated
    private static File memoizedMethodPriv$findSourceFileString(String className) {
        File applicationDir = BuildSettings.BASE_DIR;
        File file = null;
        if (applicationDir != null) {
            ArrayList arrayList;
            String fileName = StringGroovyMethods.plus(className.replace(DefaultTypeTransformation.charUnbox(ScriptBytecodeAdapter.asType(".", Character.TYPE)), File.separatorChar), (CharSequence)".groovy");
            ArrayList allFiles = (ArrayList)ScriptBytecodeAdapter.castToType(ScriptBytecodeAdapter.createList(new Object[]{new File(applicationDir, "src/main/groovy")}), ArrayList.class);
            File[] files = new File(applicationDir, "grails-app").listFiles(new FileFilter(){
                private static /* synthetic */ ClassInfo $staticClassInfo;
                public static transient /* synthetic */ boolean __$stMC;
                private transient /* synthetic */ MetaClass metaClass;
                {
                    MetaClass metaClass;
                    this.metaClass = metaClass = this.$getStaticMetaClass();
                }

                @Override
                public boolean accept(File f) {
                    return f.isDirectory() && !f.isHidden() && !f.getName().startsWith(".");
                }

                public /* synthetic */ Object methodMissing(String name, Object args) {
                    if (!(args instanceof Object[])) {
                        return ScriptBytecodeAdapter.invokeMethodN(1.class, IOUtils.class, ShortTypeHandling.castToString(new GStringImpl(new Object[]{name}, new String[]{"", ""})), new Object[]{args});
                    }
                    if (((Object[])ScriptBytecodeAdapter.castToType(args, Object[].class)).length == 1) {
                        return ScriptBytecodeAdapter.invokeMethodN(1.class, IOUtils.class, ShortTypeHandling.castToString(new GStringImpl(new Object[]{name}, new String[]{"", ""})), new Object[]{BytecodeInterface8.objectArrayGet((Object[])ScriptBytecodeAdapter.castToType(args, Object[].class), 0)});
                    }
                    return ScriptBytecodeAdapter.invokeMethodN(1.class, IOUtils.class, ShortTypeHandling.castToString(new GStringImpl(new Object[]{name}, new String[]{"", ""})), ScriptBytecodeAdapter.despreadList(new Object[0], new Object[]{args}, new int[]{0}));
                }

                public static /* synthetic */ Object $static_methodMissing(String name, Object args) {
                    if (!(args instanceof Object[])) {
                        return ScriptBytecodeAdapter.invokeMethodN(1.class, IOUtils.class, ShortTypeHandling.castToString(new GStringImpl(new Object[]{name}, new String[]{"", ""})), new Object[]{args});
                    }
                    if (((Object[])ScriptBytecodeAdapter.castToType(args, Object[].class)).length == 1) {
                        return ScriptBytecodeAdapter.invokeMethodN(1.class, IOUtils.class, ShortTypeHandling.castToString(new GStringImpl(new Object[]{name}, new String[]{"", ""})), new Object[]{BytecodeInterface8.objectArrayGet((Object[])ScriptBytecodeAdapter.castToType(args, Object[].class), 0)});
                    }
                    return ScriptBytecodeAdapter.invokeMethodN(1.class, IOUtils.class, ShortTypeHandling.castToString(new GStringImpl(new Object[]{name}, new String[]{"", ""})), ScriptBytecodeAdapter.despreadList(new Object[0], new Object[]{args}, new int[]{0}));
                }

                public /* synthetic */ void propertyMissing(String name, Object value) {
                    Object object = value;
                    ScriptBytecodeAdapter.setProperty(object, null, IOUtils.class, ShortTypeHandling.castToString(new GStringImpl(new Object[]{name}, new String[]{"", ""})));
                }

                public static /* synthetic */ void $static_propertyMissing(String name, Object value) {
                    Object object = value;
                    ScriptBytecodeAdapter.setProperty(object, null, IOUtils.class, ShortTypeHandling.castToString(new GStringImpl(new Object[]{name}, new String[]{"", ""})));
                }

                public /* synthetic */ Object propertyMissing(String name) {
                    return ScriptBytecodeAdapter.getProperty(1.class, IOUtils.class, ShortTypeHandling.castToString(new GStringImpl(new Object[]{name}, new String[]{"", ""})));
                }

                public static /* synthetic */ Object $static_propertyMissing(String name) {
                    return ScriptBytecodeAdapter.getProperty(1.class, IOUtils.class, ShortTypeHandling.castToString(new GStringImpl(new Object[]{name}, new String[]{"", ""})));
                }

                protected /* synthetic */ MetaClass $getStaticMetaClass() {
                    if (this.getClass() != 1.class) {
                        return ScriptBytecodeAdapter.initMetaClass(this);
                    }
                    ClassInfo classInfo = $staticClassInfo;
                    if (classInfo == null) {
                        $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
                    }
                    return classInfo.getMetaClass();
                }

                @Override
                @Generated
                @Internal
                @Transient
                public MetaClass getMetaClass() {
                    MetaClass metaClass = this.metaClass;
                    if (metaClass != null) {
                        return metaClass;
                    }
                    this.metaClass = this.$getStaticMetaClass();
                    return this.metaClass;
                }

                @Override
                @Generated
                @Internal
                public void setMetaClass(MetaClass metaClass) {
                    this.metaClass = metaClass;
                }
            });
            if (files != null) {
                allFiles.addAll(Arrays.asList(files));
            }
            Iterator iterator = (arrayList = allFiles) != null ? arrayList.iterator() : null;
            File dir = null;
            Iterator iterator2 = iterator;
            if (iterator2 != null) {
                while (iterator2.hasNext()) {
                    dir = (File)ScriptBytecodeAdapter.castToType(iterator2.next(), File.class);
                    File possibleFile = new File(dir, fileName);
                    if (!possibleFile.exists()) continue;
                    file = possibleFile;
                    break;
                }
            }
        }
        return file;
    }

    @Generated
    private static String memoizedMethodPriv$findApplicationDirectory() {
        String string;
        if (DefaultTypeTransformation.booleanUnbox(applicationDirectory)) {
            return applicationDirectory;
        }
        String location = null;
        try {
            String mainClassName = System.getProperty(BuildSettings.MAIN_CLASS_NAME);
            if (!DefaultTypeTransformation.booleanUnbox(mainClassName)) {
                List<StackTraceElement> stackTraceElements = DefaultGroovyMethods.reverse(Arrays.asList(Thread.currentThread().getStackTrace()));
                if (DefaultTypeTransformation.booleanUnbox(stackTraceElements)) {
                    List<StackTraceElement> list = stackTraceElements;
                    Iterator<StackTraceElement> iterator = list != null ? list.iterator() : null;
                    StackTraceElement lastElement = null;
                    Iterator<StackTraceElement> iterator2 = iterator;
                    if (iterator2 != null) {
                        while (iterator2.hasNext()) {
                            lastElement = iterator2.next();
                            String className = lastElement.getClassName();
                            String methodName = lastElement.getMethodName();
                            if (!(className.endsWith(".Application") && ScriptBytecodeAdapter.compareEqual(methodName, "<clinit>"))) continue;
                            mainClassName = className;
                            break;
                        }
                    }
                }
            }
            if (DefaultTypeTransformation.booleanUnbox(mainClassName)) {
                Class<?> mainClass = Thread.currentThread().getContextClassLoader().loadClass(mainClassName);
                URL classResource = (URL)ScriptBytecodeAdapter.castToType(mainClass != null ? IOUtils.findClassResource(mainClass) : null, URL.class);
                if (classResource != null) {
                    File file = new UrlResource(classResource).getFile();
                    String path = file.getCanonicalPath();
                    String buildClassesPath = BuildSettings.BUILD_CLASSES_PATH.replace("/", File.separator);
                    if (path.contains(buildClassesPath)) {
                        location = path.substring(0, path.indexOf(buildClassesPath) - 1);
                    } else {
                        File appDir = IOUtils.findGrailsApp(file);
                        if (appDir != null) {
                            location = appDir.getCanonicalPath();
                        }
                    }
                }
            }
        }
        catch (ClassNotFoundException e) {
        }
        catch (IOException e) {
        }
        applicationDirectory = string = location;
        return location;
    }

    public /* synthetic */ Object this$dist$invoke$2(String name, Object args) {
        if (!(args instanceof Object[])) {
            return ScriptBytecodeAdapter.invokeMethodOnCurrentN(IOUtils.class, this, ShortTypeHandling.castToString(new GStringImpl(new Object[]{name}, new String[]{"", ""})), new Object[]{args});
        }
        if (((Object[])ScriptBytecodeAdapter.castToType(args, Object[].class)).length == 1) {
            return ScriptBytecodeAdapter.invokeMethodOnCurrentN(IOUtils.class, this, ShortTypeHandling.castToString(new GStringImpl(new Object[]{name}, new String[]{"", ""})), new Object[]{BytecodeInterface8.objectArrayGet((Object[])ScriptBytecodeAdapter.castToType(args, Object[].class), 0)});
        }
        return ScriptBytecodeAdapter.invokeMethodOnCurrentN(IOUtils.class, this, ShortTypeHandling.castToString(new GStringImpl(new Object[]{name}, new String[]{"", ""})), ScriptBytecodeAdapter.despreadList(new Object[0], new Object[]{args}, new int[]{0}));
    }

    public /* synthetic */ void this$dist$set$2(String name, Object value) {
        Object object = value;
        ScriptBytecodeAdapter.setGroovyObjectProperty(object, IOUtils.class, this, ShortTypeHandling.castToString(new GStringImpl(new Object[]{name}, new String[]{"", ""})));
    }

    public /* synthetic */ Object this$dist$get$2(String name) {
        return ScriptBytecodeAdapter.getGroovyObjectProperty(IOUtils.class, this, ShortTypeHandling.castToString(new GStringImpl(new Object[]{name}, new String[]{"", ""})));
    }

    @Generated
    public static String toString(InputStream stream) {
        CallSite[] callSiteArray = IOUtils.$getCallSiteArray();
        return IOUtils.toString(stream, null);
    }

    @Generated
    public static void copy(InputStream input, Writer output) {
        CallSite[] callSiteArray = IOUtils.$getCallSiteArray();
        IOUtils.copy(input, output, null);
    }

    @Override
    @Generated
    @Internal
    @Transient
    public MetaClass getMetaClass() {
        MetaClass metaClass = this.metaClass;
        if (metaClass != null) {
            return metaClass;
        }
        this.metaClass = this.$getStaticMetaClass();
        return this.metaClass;
    }

    @Override
    @Generated
    @Internal
    public void setMetaClass(MetaClass metaClass) {
        this.metaClass = metaClass;
    }

    static {
        Closure closure;
        Closure closure2;
        Closure closure3;
        public final class __clinit__closure1
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;

            public __clinit__closure1(Object _outerInstance, Object _thisObject) {
                super(_outerInstance, _thisObject);
            }

            public File doCall(Object it) {
                return IOUtils.memoizedMethodPriv$findApplicationDirectoryFile();
            }

            @Generated
            public Object call(Object args) {
                return this.doCall(args);
            }

            @Override
            @Generated
            public Object call() {
                return this.doCall(null);
            }

            @Generated
            public File doCall() {
                CallSite[] callSiteArray = __clinit__closure1.$getCallSiteArray();
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (this.getClass() != __clinit__closure1.class) {
                    return ScriptBytecodeAdapter.initMetaClass(this);
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[]{};
                return new CallSiteArray(__clinit__closure1.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = __clinit__closure1.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        }
        memoizedMethodClosure$findApplicationDirectoryFile = closure3 = new __clinit__closure1(IOUtils.class, IOUtils.class).memoize();
        public final class __clinit__closure2
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public __clinit__closure2(Object _outerInstance, Object _thisObject) {
                super(_outerInstance, _thisObject);
            }

            public File doCall(String className) {
                return IOUtils.memoizedMethodPriv$findSourceFileString(className);
            }

            @Generated
            public File call(String className) {
                return this.doCall(className);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (this.getClass() != __clinit__closure2.class) {
                    return ScriptBytecodeAdapter.initMetaClass(this);
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
                }
                return classInfo.getMetaClass();
            }
        }
        memoizedMethodClosure$findSourceFileString = closure2 = new __clinit__closure2(IOUtils.class, IOUtils.class).memoize();
        public final class __clinit__closure3
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;

            public __clinit__closure3(Object _outerInstance, Object _thisObject) {
                super(_outerInstance, _thisObject);
            }

            public String doCall(Object it) {
                return IOUtils.memoizedMethodPriv$findApplicationDirectory();
            }

            @Generated
            public Object call(Object args) {
                return this.doCall(args);
            }

            @Override
            @Generated
            public Object call() {
                return this.doCall(null);
            }

            @Generated
            public String doCall() {
                CallSite[] callSiteArray = __clinit__closure3.$getCallSiteArray();
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (this.getClass() != __clinit__closure3.class) {
                    return ScriptBytecodeAdapter.initMetaClass(this);
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[]{};
                return new CallSiteArray(__clinit__closure3.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = __clinit__closure3.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        }
        memoizedMethodClosure$findApplicationDirectory = closure = new __clinit__closure3(IOUtils.class, IOUtils.class).memoize();
    }

    private static /* synthetic */ CallSiteArray $createCallSiteArray() {
        String[] stringArray = new String[]{};
        return new CallSiteArray(IOUtils.class, stringArray);
    }

    private static /* synthetic */ CallSite[] $getCallSiteArray() {
        CallSiteArray callSiteArray;
        if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
            callSiteArray = IOUtils.$createCallSiteArray();
            $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
        }
        return callSiteArray.array;
    }
}

