/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.inject.ast;

import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.ReflectiveAccess;
import io.micronaut.inject.ast.ClassElement;
import io.micronaut.inject.ast.Element;
import io.micronaut.inject.ast.ElementModifier;
import java.util.Collections;
import java.util.Set;

public interface MemberElement
extends Element {
    public ClassElement getDeclaringType();

    default public ClassElement getOwningType() {
        return this.getDeclaringType();
    }

    @Override
    default public Set<ElementModifier> getModifiers() {
        return Collections.emptySet();
    }

    default public boolean isReflectionRequired() {
        return this.isReflectionRequired(this.getOwningType());
    }

    default public boolean isReflectionRequired(@NonNull ClassElement callingType) {
        if (this.isPublic()) {
            return false;
        }
        if (this.isPackagePrivate() || this.isProtected()) {
            ClassElement declaringType = this.getDeclaringType();
            return !declaringType.getPackageName().equals(callingType.getPackageName());
        }
        return this.isPrivate();
    }

    default public boolean isAccessible() {
        return this.isAccessible(this.getOwningType());
    }

    default public boolean isAccessible(@NonNull ClassElement callingType) {
        return !this.isReflectionRequired(callingType) || this.hasAnnotation(ReflectiveAccess.class);
    }
}

