/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.client5.http.ssl;

import java.io.IOException;
import java.net.Socket;
import java.net.SocketAddress;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLHandshakeException;
import javax.net.ssl.SSLParameters;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocket;
import javax.security.auth.x500.X500Principal;
import org.apache.hc.client5.http.config.TlsConfig;
import org.apache.hc.client5.http.ssl.DefaultHostnameVerifier;
import org.apache.hc.client5.http.ssl.HostnameVerificationPolicy;
import org.apache.hc.client5.http.ssl.HttpClientHostnameVerifier;
import org.apache.hc.client5.http.ssl.HttpsSupport;
import org.apache.hc.client5.http.ssl.NoopHostnameVerifier;
import org.apache.hc.client5.http.ssl.SubjectName;
import org.apache.hc.client5.http.ssl.TlsSocketStrategy;
import org.apache.hc.core5.annotation.Contract;
import org.apache.hc.core5.annotation.Internal;
import org.apache.hc.core5.annotation.ThreadingBehavior;
import org.apache.hc.core5.concurrent.FutureCallback;
import org.apache.hc.core5.http.HttpHost;
import org.apache.hc.core5.http.URIScheme;
import org.apache.hc.core5.http.nio.ssl.TlsStrategy;
import org.apache.hc.core5.http.protocol.HttpContext;
import org.apache.hc.core5.http.ssl.TLS;
import org.apache.hc.core5.http.ssl.TlsCiphers;
import org.apache.hc.core5.http2.HttpVersionPolicy;
import org.apache.hc.core5.http2.ssl.ApplicationProtocol;
import org.apache.hc.core5.http2.ssl.H2TlsSupport;
import org.apache.hc.core5.io.Closer;
import org.apache.hc.core5.net.NamedEndpoint;
import org.apache.hc.core5.reactor.ssl.SSLBufferMode;
import org.apache.hc.core5.reactor.ssl.TlsDetails;
import org.apache.hc.core5.reactor.ssl.TransportSecurityLayer;
import org.apache.hc.core5.util.Args;
import org.apache.hc.core5.util.Timeout;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Contract(threading=ThreadingBehavior.STATELESS)
abstract class AbstractClientTlsStrategy
implements TlsStrategy,
TlsSocketStrategy {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractClientTlsStrategy.class);
    private final SSLContext sslContext;
    private final String[] supportedProtocols;
    private final String[] supportedCipherSuites;
    private final SSLBufferMode sslBufferManagement;
    private final HostnameVerificationPolicy hostnameVerificationPolicy;
    private final HostnameVerifier hostnameVerifier;

    AbstractClientTlsStrategy(SSLContext sslContext, String[] supportedProtocols, String[] supportedCipherSuites, SSLBufferMode sslBufferManagement, HostnameVerificationPolicy hostnameVerificationPolicy, HostnameVerifier hostnameVerifier) {
        this.sslContext = Args.notNull(sslContext, "SSL context");
        this.supportedProtocols = supportedProtocols;
        this.supportedCipherSuites = supportedCipherSuites;
        this.sslBufferManagement = sslBufferManagement != null ? sslBufferManagement : SSLBufferMode.STATIC;
        HostnameVerificationPolicy hostnameVerificationPolicy2 = this.hostnameVerificationPolicy = hostnameVerificationPolicy != null ? hostnameVerificationPolicy : HostnameVerificationPolicy.BOTH;
        this.hostnameVerifier = hostnameVerifier != null ? hostnameVerifier : (this.hostnameVerificationPolicy == HostnameVerificationPolicy.BUILTIN ? NoopHostnameVerifier.INSTANCE : HttpsSupport.getDefaultHostnameVerifier());
    }

    @Override
    @Deprecated
    public boolean upgrade(TransportSecurityLayer tlsSession, HttpHost host, SocketAddress localAddress, SocketAddress remoteAddress, Object attachment, Timeout handshakeTimeout) {
        this.upgrade(tlsSession, host, attachment, handshakeTimeout, null);
        return true;
    }

    @Override
    public void upgrade(TransportSecurityLayer tlsSession, NamedEndpoint endpoint, Object attachment, Timeout handshakeTimeout, FutureCallback<TransportSecurityLayer> callback) {
        tlsSession.startTls(this.sslContext, endpoint, this.sslBufferManagement, (e, sslEngine) -> {
            TlsConfig tlsConfig = attachment instanceof TlsConfig ? (TlsConfig)attachment : TlsConfig.DEFAULT;
            HttpVersionPolicy versionPolicy = tlsConfig.getHttpVersionPolicy();
            SSLParameters sslParameters = sslEngine.getSSLParameters();
            String[] supportedProtocols = tlsConfig.getSupportedProtocols();
            if (supportedProtocols != null) {
                sslParameters.setProtocols(supportedProtocols);
            } else if (this.supportedProtocols != null) {
                sslParameters.setProtocols(this.supportedProtocols);
            } else if (versionPolicy != HttpVersionPolicy.FORCE_HTTP_1) {
                sslParameters.setProtocols(TLS.excludeWeak(sslParameters.getProtocols()));
            }
            String[] supportedCipherSuites = tlsConfig.getSupportedCipherSuites();
            if (supportedCipherSuites != null) {
                sslParameters.setCipherSuites(supportedCipherSuites);
            } else if (this.supportedCipherSuites != null) {
                sslParameters.setCipherSuites(this.supportedCipherSuites);
            } else if (versionPolicy == HttpVersionPolicy.FORCE_HTTP_2) {
                sslParameters.setCipherSuites(TlsCiphers.excludeH2Blacklisted(sslParameters.getCipherSuites()));
            }
            if (versionPolicy != HttpVersionPolicy.FORCE_HTTP_1) {
                H2TlsSupport.setEnableRetransmissions(sslParameters, false);
            }
            this.applyParameters(sslEngine, sslParameters, H2TlsSupport.selectApplicationProtocols((Object)versionPolicy));
            if (this.hostnameVerificationPolicy == HostnameVerificationPolicy.BUILTIN || this.hostnameVerificationPolicy == HostnameVerificationPolicy.BOTH) {
                sslParameters.setEndpointIdentificationAlgorithm(URIScheme.HTTPS.id);
            }
            this.initializeEngine(sslEngine);
            if (LOG.isDebugEnabled()) {
                LOG.debug("Enabled protocols: {}", (Object)Arrays.asList(sslEngine.getEnabledProtocols()));
                LOG.debug("Enabled cipher suites: {}", (Object)Arrays.asList(sslEngine.getEnabledCipherSuites()));
                LOG.debug("Starting handshake ({})", (Object)handshakeTimeout);
            }
        }, (e, sslEngine) -> {
            this.verifySession(endpoint.getHostName(), sslEngine.getSession());
            TlsDetails tlsDetails = this.createTlsDetails(sslEngine);
            String negotiatedCipherSuite = sslEngine.getSession().getCipherSuite();
            if (tlsDetails != null && ApplicationProtocol.HTTP_2.id.equals(tlsDetails.getApplicationProtocol()) && TlsCiphers.isH2Blacklisted(negotiatedCipherSuite)) {
                throw new SSLHandshakeException("Cipher suite `" + negotiatedCipherSuite + "` does not provide adequate security for HTTP/2");
            }
            return tlsDetails;
        }, handshakeTimeout, callback);
    }

    abstract void applyParameters(SSLEngine var1, SSLParameters var2, String[] var3);

    abstract TlsDetails createTlsDetails(SSLEngine var1);

    protected void initializeEngine(SSLEngine sslEngine) {
    }

    protected void initializeSocket(SSLSocket socket) {
    }

    protected void verifySession(String hostname, SSLSession sslsession) throws SSLException {
        this.verifySession(hostname, sslsession, this.hostnameVerificationPolicy == HostnameVerificationPolicy.CLIENT || this.hostnameVerificationPolicy == HostnameVerificationPolicy.BOTH ? this.hostnameVerifier : null);
    }

    @Override
    public SSLSocket upgrade(Socket socket, String target, int port, Object attachment, HttpContext context) throws IOException {
        SSLSocket upgradedSocket = (SSLSocket)this.sslContext.getSocketFactory().createSocket(socket, target, port, false);
        try {
            this.executeHandshake(upgradedSocket, target, attachment);
            return upgradedSocket;
        }
        catch (IOException | RuntimeException ex) {
            Closer.closeQuietly(upgradedSocket);
            throw ex;
        }
    }

    private void executeHandshake(SSLSocket upgradedSocket, String target, Object attachment) throws IOException {
        TlsConfig tlsConfig = attachment instanceof TlsConfig ? (TlsConfig)attachment : TlsConfig.DEFAULT;
        SSLParameters sslParameters = upgradedSocket.getSSLParameters();
        if (this.supportedProtocols != null) {
            sslParameters.setProtocols(this.supportedProtocols);
        } else {
            sslParameters.setProtocols(TLS.excludeWeak(upgradedSocket.getEnabledProtocols()));
        }
        if (this.supportedCipherSuites != null) {
            sslParameters.setCipherSuites(this.supportedCipherSuites);
        } else {
            sslParameters.setCipherSuites(TlsCiphers.excludeWeak(upgradedSocket.getEnabledCipherSuites()));
        }
        if (this.hostnameVerificationPolicy == HostnameVerificationPolicy.BUILTIN || this.hostnameVerificationPolicy == HostnameVerificationPolicy.BOTH) {
            sslParameters.setEndpointIdentificationAlgorithm(URIScheme.HTTPS.id);
        }
        upgradedSocket.setSSLParameters(sslParameters);
        Timeout handshakeTimeout = tlsConfig.getHandshakeTimeout();
        if (handshakeTimeout != null) {
            upgradedSocket.setSoTimeout(handshakeTimeout.toMillisecondsIntBound());
        }
        this.initializeSocket(upgradedSocket);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Enabled protocols: {}", (Object)upgradedSocket.getEnabledProtocols());
            LOG.debug("Enabled cipher suites: {}", (Object)upgradedSocket.getEnabledCipherSuites());
            LOG.debug("Starting handshake ({})", (Object)handshakeTimeout);
        }
        upgradedSocket.startHandshake();
        this.verifySession(target, upgradedSocket.getSession());
    }

    void verifySession(String hostname, SSLSession sslsession, HostnameVerifier hostnameVerifier) throws SSLException {
        Certificate[] certs;
        if (LOG.isDebugEnabled()) {
            LOG.debug("Secure session established");
            LOG.debug(" negotiated protocol: {}", (Object)sslsession.getProtocol());
            LOG.debug(" negotiated cipher suite: {}", (Object)sslsession.getCipherSuite());
            try {
                certs = sslsession.getPeerCertificates();
                Certificate cert = certs[0];
                if (cert instanceof X509Certificate) {
                    X509Certificate x509 = (X509Certificate)cert;
                    X500Principal peer = x509.getSubjectX500Principal();
                    LOG.debug("Peer principal: {}", (Object)this.toEscapedString(peer));
                    Collection<List<?>> altNames1 = x509.getSubjectAlternativeNames();
                    if (altNames1 != null) {
                        ArrayList<String> altNames = new ArrayList<String>();
                        for (List<?> aC : altNames1) {
                            if (aC.isEmpty()) continue;
                            altNames.add(Objects.toString(aC.get(1), null));
                        }
                        LOG.debug(" peer alternative names: {}", (Object)altNames);
                    }
                    X500Principal issuer = x509.getIssuerX500Principal();
                    LOG.debug("Issuer principal: {}", (Object)this.toEscapedString(issuer));
                    Collection<List<?>> altNames2 = x509.getIssuerAlternativeNames();
                    if (altNames2 != null) {
                        ArrayList<String> altNames = new ArrayList<String>();
                        for (List<?> aC : altNames2) {
                            if (aC.isEmpty()) continue;
                            altNames.add(Objects.toString(aC.get(1), null));
                        }
                        LOG.debug(" issuer alternative names: {}", (Object)altNames);
                    }
                }
            }
            catch (Exception certs2) {
                // empty catch block
            }
        }
        if (hostnameVerifier != null) {
            certs = sslsession.getPeerCertificates();
            if (certs.length < 1) {
                throw new SSLPeerUnverifiedException("Peer certificate chain is empty");
            }
            Certificate peerCertificate = certs[0];
            if (!(peerCertificate instanceof X509Certificate)) {
                throw new SSLPeerUnverifiedException("Unexpected certificate type: " + peerCertificate.getType());
            }
            X509Certificate x509Certificate = (X509Certificate)peerCertificate;
            if (hostnameVerifier instanceof HttpClientHostnameVerifier) {
                ((HttpClientHostnameVerifier)hostnameVerifier).verify(hostname, x509Certificate);
            } else if (!hostnameVerifier.verify(hostname, sslsession)) {
                List<SubjectName> subjectAlts = DefaultHostnameVerifier.getSubjectAltNames(x509Certificate);
                throw new SSLPeerUnverifiedException("Certificate for <" + hostname + "> doesn't match any of the subject alternative names: " + subjectAlts);
            }
        }
    }

    @Internal
    String toEscapedString(X500Principal principal2) {
        String principalValue = principal2.getName("RFC2253");
        StringBuilder sanitizedPrincipal = new StringBuilder(principalValue.length());
        for (char c : principalValue.toCharArray()) {
            if (Character.isISOControl(c)) {
                sanitizedPrincipal.append(String.format("\\x%02x", c));
                continue;
            }
            sanitizedPrincipal.append(c);
        }
        return sanitizedPrincipal.toString();
    }
}

