/*
 * Decompiled with CFR 0.152.
 */
package org.grails.cli.boot;

import grails.util.Environment;
import groovy.lang.Grab;
import groovy.lang.GroovyClassLoader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.codehaus.groovy.ast.AnnotationNode;
import org.codehaus.groovy.ast.ClassHelper;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.Parameter;
import org.codehaus.groovy.ast.expr.ClassExpression;
import org.codehaus.groovy.ast.expr.ConstantExpression;
import org.codehaus.groovy.ast.stmt.ReturnStatement;
import org.codehaus.groovy.classgen.GeneratorContext;
import org.codehaus.groovy.control.CompilationFailedException;
import org.codehaus.groovy.control.SourceUnit;
import org.codehaus.groovy.control.customizers.ImportCustomizer;
import org.eclipse.aether.graph.Dependency;
import org.grails.cli.boot.GrailsDependencyVersions;
import org.grails.cli.compiler.AstUtils;
import org.grails.cli.compiler.CompilerAutoConfiguration;
import org.grails.cli.compiler.DependencyCustomizer;
import org.grails.cli.compiler.GroovyCompilerConfiguration;
import org.grails.cli.compiler.autoconfigure.SpringMvcCompilerAutoConfiguration;
import org.grails.cli.compiler.dependencies.Dependency;
import org.grails.cli.compiler.dependencies.DependencyManagement;
import org.grails.cli.compiler.grape.DependencyResolutionContext;

public class GrailsApplicationCompilerAutoConfiguration
extends CompilerAutoConfiguration {
    public static final String[] DEFAULT_IMPORTS = new String[]{"grails.persistence", "grails.gorm", "grails.rest", "grails.artefact", "grails.web", "grails.boot.config"};
    public static final String ENABLE_AUTO_CONFIGURATION = "org.springframework.boot.autoconfigure.EnableAutoConfiguration";
    public static final ClassNode ENABLE_AUTO_CONFIGURATION_CLASS_NODE = ClassHelper.make("org.springframework.boot.autoconfigure.EnableAutoConfiguration");
    ClassNode lastMatch = null;

    @Override
    public boolean matches(ClassNode classNode) {
        boolean matches = AstUtils.hasAtLeastOneAnnotation(classNode, "grails.persistence.Entity", "grails.rest.Resource", "Resource", "grails.artefact.Artefact", "grails.web.Controller");
        if (matches) {
            this.lastMatch = classNode;
        }
        return matches;
    }

    @Override
    public void applyDependencies(DependencyCustomizer dependencies2) throws CompilationFailedException {
        this.addManagedDependencies(dependencies2);
        if (this.lastMatch != null) {
            this.lastMatch.addAnnotation(GrailsApplicationCompilerAutoConfiguration.createGrabAnnotation("org.apache.grails", "grails-dependencies", Environment.class.getPackage().getImplementationVersion(), null, "pom", true));
            this.lastMatch.addAnnotation(GrailsApplicationCompilerAutoConfiguration.createGrabAnnotation("org.apache.grails", "grails-web-boot", Environment.class.getPackage().getImplementationVersion(), null, null, true));
        }
        new SpringMvcCompilerAutoConfiguration().applyDependencies(dependencies2);
    }

    private void addManagedDependencies(DependencyCustomizer dependencies2) {
        List<Dependency> current = dependencies2.getDependencyResolutionContext().getManagedDependencies();
        DependencyResolutionContext resolutionContext = dependencies2.getDependencyResolutionContext();
        resolutionContext.addDependencyManagement(new GrailsDependencies(current));
        resolutionContext.addDependencyManagement(this.getAdditionalDependencies());
    }

    protected DependencyManagement getAdditionalDependencies() {
        return new GrailsDependencyVersions();
    }

    public static AnnotationNode createGrabAnnotation(String group, String module, String version, String classifier, String type, boolean transitive) {
        AnnotationNode annotationNode = new AnnotationNode(new ClassNode(Grab.class));
        annotationNode.addMember("group", new ConstantExpression(group));
        annotationNode.addMember("module", new ConstantExpression(module));
        annotationNode.addMember("version", new ConstantExpression(version));
        if (classifier != null) {
            annotationNode.addMember("classifier", new ConstantExpression(classifier));
        }
        if (type != null) {
            annotationNode.addMember("type", new ConstantExpression(type));
        }
        annotationNode.addMember("transitive", new ConstantExpression(transitive));
        annotationNode.addMember("initClass", new ConstantExpression(false));
        return annotationNode;
    }

    @Override
    public void applyImports(ImportCustomizer imports) throws CompilationFailedException {
        imports.addStarImports(DEFAULT_IMPORTS);
        new SpringMvcCompilerAutoConfiguration().applyImports(imports);
    }

    @Override
    public void applyToMainClass(GroovyClassLoader loader, GroovyCompilerConfiguration configuration, GeneratorContext generatorContext, SourceUnit source, ClassNode classNode) throws CompilationFailedException {
        ClassNode applicationClassNode = new ClassNode("Application", 1, ClassHelper.make("grails.boot.config.GrailsAutoConfiguration"));
        AnnotationNode enableAutoAnnotation = new AnnotationNode(ENABLE_AUTO_CONFIGURATION_CLASS_NODE);
        try {
            enableAutoAnnotation.addMember("exclude", new ClassExpression(ClassHelper.make("org.springframework.boot.autoconfigure.jdbc.DataSourceAutoConfiguration")));
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        applicationClassNode.addAnnotation(enableAutoAnnotation);
        applicationClassNode.setModule(source.getAST());
        applicationClassNode.addMethod("shouldScanDefaultPackage", 1, ClassHelper.Boolean_TYPE, new Parameter[0], null, new ReturnStatement(new ConstantExpression(Boolean.TRUE)));
        source.getAST().getClasses().add(0, applicationClassNode);
        classNode.addAnnotation(new AnnotationNode(ClassHelper.make("org.grails.boot.internal.EnableAutoConfiguration")));
    }

    class GrailsDependencies
    implements DependencyManagement {
        private Map<String, org.grails.cli.compiler.dependencies.Dependency> groupAndArtifactToDependency = new HashMap<String, org.grails.cli.compiler.dependencies.Dependency>();
        private Map<String, String> artifactToGroupAndArtifact = new HashMap<String, String>();
        private List<org.grails.cli.compiler.dependencies.Dependency> dependencies = new ArrayList<org.grails.cli.compiler.dependencies.Dependency>();

        public GrailsDependencies(List<Dependency> dependencies2) {
            for (Dependency dependency : dependencies2) {
                String groupId = dependency.getArtifact().getGroupId();
                String artifactId = dependency.getArtifact().getArtifactId();
                String version = dependency.getArtifact().getVersion();
                ArrayList<Dependency.Exclusion> exclusions = new ArrayList<Dependency.Exclusion>();
                org.grails.cli.compiler.dependencies.Dependency value = new org.grails.cli.compiler.dependencies.Dependency(groupId, artifactId, version, exclusions);
                this.dependencies.add(value);
                this.groupAndArtifactToDependency.put(groupId + ":" + artifactId, value);
                this.artifactToGroupAndArtifact.put(artifactId, groupId + ":" + artifactId);
            }
        }

        @Override
        public List<org.grails.cli.compiler.dependencies.Dependency> getDependencies() {
            return this.dependencies;
        }

        @Override
        public String getSpringBootVersion() {
            return this.find("spring-boot").getVersion();
        }

        @Override
        public org.grails.cli.compiler.dependencies.Dependency find(String artifactId) {
            String groupAndArtifact = this.artifactToGroupAndArtifact.get(artifactId);
            if (groupAndArtifact == null) {
                return null;
            }
            return this.groupAndArtifactToDependency.get(groupAndArtifact);
        }
    }
}

