/*
 * Decompiled with CFR 0.152.
 */
package org.grails.encoder;

import java.util.Arrays;
import java.util.Collections;
import java.util.Set;
import org.grails.encoder.CodecIdentifier;
import org.grails.encoder.CodecIdentifierProvider;
import org.springframework.util.StringUtils;

public class CombinedCodecIdentifier
implements CodecIdentifier {
    private CodecIdentifier[] codecIdentifiers;
    private String codecName;
    private String codecAlias;

    CombinedCodecIdentifier(CodecIdentifierProvider[] encodersOrDecoders) {
        this(encodersOrDecoders, false);
    }

    CombinedCodecIdentifier(CodecIdentifierProvider[] encodersOrDecoders, boolean reverseOrder) {
        int size = encodersOrDecoders.length;
        this.codecIdentifiers = new CodecIdentifier[size];
        String[] encoderNamesArr = new String[size];
        for (int i2 = 0; i2 < size; ++i2) {
            int targetIndex = reverseOrder ? size - 1 - i2 : i2;
            this.codecIdentifiers[targetIndex] = encodersOrDecoders[i2].getCodecIdentifier();
            encoderNamesArr[targetIndex] = this.codecIdentifiers[targetIndex].getCodecName();
        }
        this.codecName = StringUtils.collectionToDelimitedString(Arrays.asList(encoderNamesArr), "And");
        this.codecAlias = StringUtils.collectionToCommaDelimitedString(Arrays.asList(encoderNamesArr));
    }

    @Override
    public String getCodecName() {
        return this.codecName;
    }

    @Override
    public Set<String> getCodecAliases() {
        return Collections.singleton(this.codecAlias);
    }

    @Override
    public boolean isEquivalent(CodecIdentifier other) {
        for (CodecIdentifier codecIdentifier : this.codecIdentifiers) {
            if (!codecIdentifier.isEquivalent(other)) continue;
            return true;
        }
        return false;
    }
}

