/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.cosmosdb.internal.directconnectivity;

import com.microsoft.azure.cosmosdb.ConsistencyLevel;
import com.microsoft.azure.cosmosdb.DocumentClientException;
import com.microsoft.azure.cosmosdb.internal.directconnectivity.GatewayServiceConfigurationReader;
import com.microsoft.azure.cosmosdb.rx.internal.BadRequestException;
import com.microsoft.azure.cosmosdb.rx.internal.RxDocumentServiceRequest;
import com.microsoft.azure.cosmosdb.rx.internal.Strings;
import org.apache.commons.lang3.EnumUtils;

public class RequestHelper {
    public static ConsistencyLevel GetConsistencyLevelToUse(GatewayServiceConfigurationReader serviceConfigReader, RxDocumentServiceRequest request) throws DocumentClientException {
        ConsistencyLevel consistencyLevelToUse = serviceConfigReader.getDefaultConsistencyLevel();
        String requestConsistencyLevelHeaderValue = (String)request.getHeaders().get("x-ms-consistency-level");
        if (!Strings.isNullOrEmpty((String)requestConsistencyLevelHeaderValue)) {
            ConsistencyLevel requestConsistencyLevel = (ConsistencyLevel)EnumUtils.getEnum(ConsistencyLevel.class, (String)requestConsistencyLevelHeaderValue);
            if (requestConsistencyLevel == null) {
                throw new BadRequestException(String.format("Value '%s' specified for the header '%s' is invalid.", requestConsistencyLevelHeaderValue, "x-ms-consistency-level"));
            }
            consistencyLevelToUse = requestConsistencyLevel;
        }
        return consistencyLevelToUse;
    }
}

