/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.tools.dynamometer.blockgenerator;

import java.io.IOException;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.Mapper;
import org.apache.hadoop.tools.dynamometer.blockgenerator.BlockInfo;
import org.apache.hadoop.tools.dynamometer.blockgenerator.XMLParser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XMLParserMapper
extends Mapper<LongWritable, Text, IntWritable, BlockInfo> {
    private static final Logger LOG = LoggerFactory.getLogger(XMLParserMapper.class);
    private int blockIndex = 0;
    private int numDataNodes;
    private XMLParser parser;

    public void setup(Mapper.Context context) {
        Configuration conf = context.getConfiguration();
        this.numDataNodes = conf.getInt("dyno.blockgen.num.datanodes", -1);
        this.parser = new XMLParser();
    }

    public void map(LongWritable lineNum, Text line, Mapper.Context context) throws IOException, InterruptedException {
        List<BlockInfo> blockInfos = this.parser.parseLine(line.toString());
        for (BlockInfo blockInfo : blockInfos) {
            for (short i = 0; i < blockInfo.getReplication(); i = (short)(i + 1)) {
                context.write((Object)new IntWritable((this.blockIndex + i) % this.numDataNodes), (Object)blockInfo);
            }
            ++this.blockIndex;
            if (this.blockIndex % 1000000 != 0) continue;
            LOG.info("Processed " + this.blockIndex + " blocks");
        }
    }
}

