/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.nodemanager.api.deviceplugin;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeSet;
import org.apache.hadoop.yarn.server.nodemanager.api.deviceplugin.MountDeviceSpec;
import org.apache.hadoop.yarn.server.nodemanager.api.deviceplugin.MountVolumeSpec;
import org.apache.hadoop.yarn.server.nodemanager.api.deviceplugin.VolumeSpec;

public final class DeviceRuntimeSpec
implements Serializable {
    private static final long serialVersionUID = 554704120015467660L;
    private final String containerRuntime;
    private final Map<String, String> envs;
    private final Set<MountVolumeSpec> volumeMounts;
    private final Set<MountDeviceSpec> deviceMounts;
    private final Set<VolumeSpec> volumeSpecs;

    private DeviceRuntimeSpec(Builder builder) {
        this.containerRuntime = builder.containerRuntime;
        this.deviceMounts = builder.deviceMounts;
        this.envs = builder.envs;
        this.volumeSpecs = builder.volumeSpecs;
        this.volumeMounts = builder.volumeMounts;
    }

    public String getContainerRuntime() {
        return this.containerRuntime;
    }

    public Map<String, String> getEnvs() {
        return this.envs;
    }

    public Set<MountVolumeSpec> getVolumeMounts() {
        return this.volumeMounts;
    }

    public Set<MountDeviceSpec> getDeviceMounts() {
        return this.deviceMounts;
    }

    public Set<VolumeSpec> getVolumeSpecs() {
        return this.volumeSpecs;
    }

    public static final class Builder {
        private String containerRuntime = "";
        private Map<String, String> envs = new HashMap<String, String>();
        private Set<MountVolumeSpec> volumeMounts;
        private Set<MountDeviceSpec> deviceMounts;
        private Set<VolumeSpec> volumeSpecs = new TreeSet<VolumeSpec>();

        private Builder() {
            this.deviceMounts = new TreeSet<MountDeviceSpec>();
            this.volumeMounts = new TreeSet<MountVolumeSpec>();
        }

        public static Builder newInstance() {
            return new Builder();
        }

        public DeviceRuntimeSpec build() {
            return new DeviceRuntimeSpec(this);
        }

        public Builder setContainerRuntime(String cRuntime) {
            this.containerRuntime = cRuntime;
            return this;
        }

        public Builder addVolumeSpec(VolumeSpec spec) {
            this.volumeSpecs.add(spec);
            return this;
        }

        public Builder addMountVolumeSpec(MountVolumeSpec spec) {
            this.volumeMounts.add(spec);
            return this;
        }

        public Builder addMountDeviceSpec(MountDeviceSpec spec) {
            this.deviceMounts.add(spec);
            return this;
        }

        public Builder addEnv(String key, String value) {
            this.envs.put(Objects.requireNonNull(key), Objects.requireNonNull(value));
            return this;
        }
    }
}

