/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.monitor;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.util.ReflectionUtils;
import org.apache.hadoop.util.Sets;
import org.apache.hadoop.yarn.exceptions.YarnException;
import org.apache.hadoop.yarn.server.resourcemanager.RMContext;
import org.apache.hadoop.yarn.server.resourcemanager.monitor.SchedulingEditPolicy;
import org.apache.hadoop.yarn.server.resourcemanager.monitor.SchedulingMonitor;
import org.apache.hadoop.yarn.server.resourcemanager.monitor.capacity.ProportionalCapacityPreemptionPolicy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SchedulingMonitorManager {
    private static final Logger LOG = LoggerFactory.getLogger(SchedulingMonitorManager.class);
    private Map<String, SchedulingMonitor> runningSchedulingMonitors = new HashMap<String, SchedulingMonitor>();
    private RMContext rmContext;

    private void updateSchedulingMonitors(Configuration conf, boolean startImmediately) throws YarnException {
        boolean monitorsEnabled = conf.getBoolean("yarn.resourcemanager.scheduler.monitor.enable", false);
        if (!monitorsEnabled) {
            if (!this.runningSchedulingMonitors.isEmpty()) {
                LOG.info("Scheduling Monitor disabled, stopping all services");
                this.stopAndRemoveAll();
            }
            return;
        }
        String[] configuredPolicies = conf.getTrimmedStrings("yarn.resourcemanager.scheduler.monitor.policies");
        if (configuredPolicies == null || configuredPolicies.length == 0) {
            return;
        }
        HashSet<String> configurePoliciesSet = new HashSet<String>();
        for (String s : configuredPolicies) {
            configurePoliciesSet.add(s);
        }
        for (String s : configurePoliciesSet) {
            Class<?> policyClass;
            if (this.runningSchedulingMonitors.containsKey(s)) continue;
            try {
                policyClass = Class.forName(s);
            }
            catch (ClassNotFoundException e) {
                String message = "Failed to find class of specified policy=" + s;
                LOG.warn(message);
                throw new YarnException(message);
            }
            if (SchedulingEditPolicy.class.isAssignableFrom(policyClass)) {
                SchedulingEditPolicy policyInstance = (SchedulingEditPolicy)ReflectionUtils.newInstance(policyClass, null);
                SchedulingMonitor mon = new SchedulingMonitor(this.rmContext, policyInstance);
                mon.init(conf);
                if (startImmediately) {
                    mon.start();
                }
                this.runningSchedulingMonitors.put(s, mon);
                continue;
            }
            String message = "Specified policy=" + s + " is not a SchedulingEditPolicy class.";
            LOG.warn(message);
            throw new YarnException(message);
        }
        Set disabledPolicies = Sets.difference(this.runningSchedulingMonitors.keySet(), configurePoliciesSet);
        for (String disabledPolicy : disabledPolicies) {
            LOG.info("SchedulingEditPolicy=" + disabledPolicy + " removed, stopping it now ...");
            this.silentlyStopSchedulingMonitor(disabledPolicy);
            this.runningSchedulingMonitors.remove(disabledPolicy);
        }
    }

    public synchronized void initialize(RMContext rmContext, Configuration configuration) throws YarnException {
        this.rmContext = rmContext;
        this.stopAndRemoveAll();
        this.updateSchedulingMonitors(configuration, false);
    }

    public synchronized void reinitialize(RMContext rmContext, Configuration configuration) throws YarnException {
        this.rmContext = rmContext;
        this.updateSchedulingMonitors(configuration, true);
    }

    public synchronized void startAll() {
        for (SchedulingMonitor schedulingMonitor : this.runningSchedulingMonitors.values()) {
            schedulingMonitor.start();
        }
    }

    private void silentlyStopSchedulingMonitor(String name) {
        SchedulingMonitor mon = this.runningSchedulingMonitors.get(name);
        try {
            mon.stop();
            LOG.info("Sucessfully stopped monitor=" + mon.getName());
        }
        catch (Exception e) {
            LOG.warn("Exception while stopping monitor=" + mon.getName(), (Throwable)e);
        }
    }

    private void stopAndRemoveAll() {
        if (!this.runningSchedulingMonitors.isEmpty()) {
            for (String schedulingMonitorName : this.runningSchedulingMonitors.keySet()) {
                this.silentlyStopSchedulingMonitor(schedulingMonitorName);
            }
            this.runningSchedulingMonitors.clear();
        }
    }

    public boolean isRSMEmpty() {
        return this.runningSchedulingMonitors.isEmpty();
    }

    public boolean isSameConfiguredPolicies(Set<String> configurePoliciesSet) {
        return configurePoliciesSet.equals(this.runningSchedulingMonitors.keySet());
    }

    public SchedulingMonitor getAvailableSchedulingMonitor() {
        if (this.isRSMEmpty()) {
            return null;
        }
        for (SchedulingMonitor smon : this.runningSchedulingMonitors.values()) {
            if (!(smon.getSchedulingEditPolicy() instanceof ProportionalCapacityPreemptionPolicy)) continue;
            return smon;
        }
        return null;
    }

    public synchronized void stop() throws YarnException {
        this.stopAndRemoveAll();
    }
}

