/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.monitor.capacity;

import java.util.List;
import org.apache.hadoop.yarn.api.records.NodeId;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.server.resourcemanager.rmcontainer.RMContainer;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.common.fica.FiCaSchedulerNode;
import org.apache.hadoop.yarn.util.resource.Resources;

public class TempSchedulerNode {
    private List<RMContainer> runningContainers;
    private RMContainer reservedContainer;
    private Resource totalResource;
    private Resource allocatedResource;
    private Resource availableResource;
    private Resource reservedResource;
    private NodeId nodeId;

    public static TempSchedulerNode fromSchedulerNode(FiCaSchedulerNode schedulerNode) {
        TempSchedulerNode n = new TempSchedulerNode();
        n.totalResource = Resources.clone((Resource)schedulerNode.getTotalResource());
        n.allocatedResource = Resources.clone((Resource)schedulerNode.getAllocatedResource());
        n.runningContainers = schedulerNode.getCopiedListOfRunningContainers();
        n.reservedContainer = schedulerNode.getReservedContainer();
        n.reservedResource = n.reservedContainer != null ? n.reservedContainer.getReservedResource() : Resources.none();
        n.availableResource = Resources.subtract((Resource)n.totalResource, (Resource)n.allocatedResource);
        n.nodeId = schedulerNode.getNodeID();
        return n;
    }

    public NodeId getNodeId() {
        return this.nodeId;
    }

    public List<RMContainer> getRunningContainers() {
        return this.runningContainers;
    }

    public void setRunningContainers(List<RMContainer> runningContainers) {
        this.runningContainers = runningContainers;
    }

    public RMContainer getReservedContainer() {
        return this.reservedContainer;
    }

    public void setReservedContainer(RMContainer reservedContainer) {
        this.reservedContainer = reservedContainer;
    }

    public Resource getTotalResource() {
        return this.totalResource;
    }

    public void setTotalResource(Resource totalResource) {
        this.totalResource = totalResource;
    }

    public Resource getAllocatedResource() {
        return this.allocatedResource;
    }

    public void setAllocatedResource(Resource allocatedResource) {
        this.allocatedResource = allocatedResource;
    }

    public Resource getAvailableResource() {
        return this.availableResource;
    }

    public void setAvailableResource(Resource availableResource) {
        this.availableResource = availableResource;
    }

    public Resource getReservedResource() {
        return this.reservedResource;
    }

    public void setReservedResource(Resource reservedResource) {
        this.reservedResource = reservedResource;
    }
}

