/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.placement;

import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.yarn.api.records.ApplicationSubmissionContext;
import org.apache.hadoop.yarn.exceptions.YarnException;
import org.apache.hadoop.yarn.server.resourcemanager.placement.ApplicationPlacementContext;
import org.apache.hadoop.yarn.server.resourcemanager.placement.FSPlacementRule;
import org.apache.hadoop.yarn.server.resourcemanager.placement.FairQueuePlacementUtils;
import org.apache.hadoop.yarn.server.resourcemanager.placement.PlacementRule;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.FSLeafQueue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public class UserPlacementRule
extends FSPlacementRule {
    private static final Logger LOG = LoggerFactory.getLogger(UserPlacementRule.class);

    @Override
    public ApplicationPlacementContext getPlacementForApp(ApplicationSubmissionContext asc, String user) throws YarnException {
        String queueName;
        String cleanUser = FairQueuePlacementUtils.cleanName(user);
        PlacementRule parentRule = this.getParentRule();
        if (parentRule != null) {
            LOG.debug("User rule: parent rule found: {}", (Object)parentRule.getName());
            ApplicationPlacementContext parent = parentRule.getPlacementForApp(asc, user);
            if (parent == null || this.getQueueManager().getQueue(parent.getQueue()) instanceof FSLeafQueue) {
                LOG.debug("User rule: parent rule failed");
                return null;
            }
            LOG.debug("User rule: parent rule result: {}", (Object)parent.getQueue());
            queueName = parent.getQueue() + "." + cleanUser;
        } else {
            queueName = FairQueuePlacementUtils.assureRoot(cleanUser);
        }
        if (this.createQueue || this.configuredQueue(queueName)) {
            return new ApplicationPlacementContext(queueName);
        }
        return null;
    }
}

