/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.federation.store;

import java.io.IOException;
import java.util.Set;
import org.apache.hadoop.hdfs.server.federation.store.DisabledNameserviceStore;
import org.apache.hadoop.hdfs.server.federation.store.FederationStateStoreTestUtils;
import org.apache.hadoop.hdfs.server.federation.store.TestStateStoreBase;
import org.apache.hadoop.hdfs.server.federation.store.records.DisabledNameservice;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestStateStoreDisabledNameservice
extends TestStateStoreBase {
    private static DisabledNameserviceStore disabledStore;

    @Before
    public void setup() throws IOException, InterruptedException {
        disabledStore = (DisabledNameserviceStore)TestStateStoreDisabledNameservice.getStateStore().getRegisteredRecordStore(DisabledNameserviceStore.class);
        Assert.assertTrue((boolean)FederationStateStoreTestUtils.clearRecords(TestStateStoreDisabledNameservice.getStateStore(), DisabledNameservice.class));
    }

    @Test
    public void testDisableNameservice() throws IOException {
        Set disabledNameservices = disabledStore.getDisabledNameservices();
        Assert.assertEquals((long)0L, (long)disabledNameservices.size());
        disabledStore.disableNameservice("ns0");
        disabledStore.disableNameservice("ns1");
        disabledStore.loadCache(true);
        disabledNameservices = disabledStore.getDisabledNameservices();
        Assert.assertEquals((long)2L, (long)disabledNameservices.size());
        Assert.assertTrue((disabledNameservices.contains("ns0") && disabledNameservices.contains("ns1") ? 1 : 0) != 0);
        disabledStore.enableNameservice("ns0");
        disabledStore.loadCache(true);
        disabledNameservices = disabledStore.getDisabledNameservices();
        Assert.assertEquals((long)1L, (long)disabledNameservices.size());
        Assert.assertTrue((boolean)disabledNameservices.contains("ns1"));
    }
}

