/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.diskbalancer;

import java.net.URI;
import java.util.List;
import java.util.UUID;
import org.apache.hadoop.fs.StorageType;
import org.apache.hadoop.hdfs.server.diskbalancer.DiskBalancerTestUtil;
import org.apache.hadoop.hdfs.server.diskbalancer.connectors.ClusterConnector;
import org.apache.hadoop.hdfs.server.diskbalancer.connectors.ConnectorFactory;
import org.apache.hadoop.hdfs.server.diskbalancer.connectors.NullConnector;
import org.apache.hadoop.hdfs.server.diskbalancer.datamodel.DiskBalancerCluster;
import org.apache.hadoop.hdfs.server.diskbalancer.datamodel.DiskBalancerDataNode;
import org.apache.hadoop.hdfs.server.diskbalancer.datamodel.DiskBalancerVolume;
import org.apache.hadoop.hdfs.server.diskbalancer.datamodel.DiskBalancerVolumeSet;
import org.apache.hadoop.hdfs.server.diskbalancer.planner.GreedyPlanner;
import org.apache.hadoop.hdfs.server.diskbalancer.planner.NodePlan;
import org.apache.hadoop.hdfs.server.diskbalancer.planner.Step;
import org.junit.Assert;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestPlanner {
    static final Logger LOG = LoggerFactory.getLogger(TestPlanner.class);

    @Test
    public void testGreedyPlannerBalanceVolumeSet() throws Exception {
        URI clusterJson = this.getClass().getResource("/diskBalancer/data-cluster-3node-3disk.json").toURI();
        ClusterConnector jsonConnector = ConnectorFactory.getCluster((URI)clusterJson, null);
        DiskBalancerCluster cluster = new DiskBalancerCluster(jsonConnector);
        cluster.readClusterInfo();
        Assert.assertEquals((long)3L, (long)cluster.getNodes().size());
        cluster.setNodesToProcess(cluster.getNodes());
        DiskBalancerDataNode node = (DiskBalancerDataNode)cluster.getNodes().get(0);
        GreedyPlanner planner = new GreedyPlanner(10.0, node);
        NodePlan plan = new NodePlan(node.getDataNodeName(), node.getDataNodePort());
        planner.balanceVolumeSet(node, (DiskBalancerVolumeSet)node.getVolumeSets().get("SSD"), plan);
    }

    @Test
    public void testGreedyPlannerComputePlan() throws Exception {
        URI clusterJson = this.getClass().getResource("/diskBalancer/data-cluster-3node-3disk.json").toURI();
        ClusterConnector jsonConnector = ConnectorFactory.getCluster((URI)clusterJson, null);
        DiskBalancerCluster cluster = new DiskBalancerCluster(jsonConnector);
        cluster.readClusterInfo();
        Assert.assertEquals((long)3L, (long)cluster.getNodes().size());
        cluster.setNodesToProcess(cluster.getNodes());
        List plan = cluster.computePlan(10.0);
        Assert.assertNotNull((Object)plan);
    }

    private DiskBalancerVolume createVolume(String path, int capacityInGB, int usedInGB) {
        DiskBalancerTestUtil util = new DiskBalancerTestUtil();
        DiskBalancerVolume volume = util.createRandomVolume(StorageType.SSD);
        volume.setPath(path);
        volume.setCapacity((long)capacityInGB * 0x40000000L);
        volume.setReserved(0L);
        volume.setUsed((long)usedInGB * 0x40000000L);
        return volume;
    }

    @Test
    public void testGreedyPlannerNoNodeCluster() throws Exception {
        GreedyPlanner planner = new GreedyPlanner(10.0, null);
        Assert.assertNotNull((Object)planner);
    }

    @Test
    public void testGreedyPlannerNoVolumeTest() throws Exception {
        NullConnector nullConnector = new NullConnector();
        DiskBalancerCluster cluster = new DiskBalancerCluster((ClusterConnector)nullConnector);
        List planList = cluster.computePlan(10.0);
        Assert.assertNotNull((Object)planList);
    }

    @Test
    public void testGreedyPlannerOneVolumeNoPlanTest() throws Exception {
        NullConnector nullConnector = new NullConnector();
        DiskBalancerCluster cluster = new DiskBalancerCluster((ClusterConnector)nullConnector);
        DiskBalancerDataNode node = new DiskBalancerDataNode(UUID.randomUUID().toString());
        DiskBalancerVolume volume30 = this.createVolume("volume30", 100, 30);
        node.addVolume(volume30);
        nullConnector.addNode(node);
        cluster.readClusterInfo();
        Assert.assertEquals((long)1L, (long)cluster.getNodes().size());
        GreedyPlanner planner = new GreedyPlanner(10.0, node);
        NodePlan plan = new NodePlan(node.getDataNodeName(), node.getDataNodePort());
        planner.balanceVolumeSet(node, (DiskBalancerVolumeSet)node.getVolumeSets().get("SSD"), plan);
        Assert.assertEquals((long)0L, (long)plan.getVolumeSetPlans().size());
    }

    @Test
    public void testGreedyPlannerTwoVolume() throws Exception {
        NullConnector nullConnector = new NullConnector();
        DiskBalancerCluster cluster = new DiskBalancerCluster((ClusterConnector)nullConnector);
        DiskBalancerDataNode node = new DiskBalancerDataNode(UUID.randomUUID().toString());
        DiskBalancerVolume volume30 = this.createVolume("volume30", 100, 30);
        DiskBalancerVolume volume10 = this.createVolume("volume10", 100, 10);
        node.addVolume(volume10);
        node.addVolume(volume30);
        nullConnector.addNode(node);
        cluster.readClusterInfo();
        Assert.assertEquals((long)1L, (long)cluster.getNodes().size());
        GreedyPlanner planner = new GreedyPlanner(5.0, node);
        NodePlan plan = new NodePlan(node.getDataNodeUUID(), node.getDataNodePort());
        planner.balanceVolumeSet(node, (DiskBalancerVolumeSet)node.getVolumeSets().get("SSD"), plan);
        Assert.assertEquals((long)1L, (long)plan.getVolumeSetPlans().size());
        Step step = (Step)plan.getVolumeSetPlans().get(0);
        Assert.assertEquals((Object)"volume30", (Object)step.getSourceVolume().getPath());
        Assert.assertEquals((Object)"volume10", (Object)step.getDestinationVolume().getPath());
        Assert.assertEquals((Object)"10 G", (Object)step.getSizeString(step.getBytesToMove()));
    }

    @Test
    public void testGreedyPlannerEqualizeData() throws Exception {
        NullConnector nullConnector = new NullConnector();
        DiskBalancerCluster cluster = new DiskBalancerCluster((ClusterConnector)nullConnector);
        DiskBalancerDataNode node = new DiskBalancerDataNode(UUID.randomUUID().toString());
        DiskBalancerVolume volume30 = this.createVolume("volume30", 100, 30);
        DiskBalancerVolume volume20 = this.createVolume("volume20", 100, 20);
        DiskBalancerVolume volume10 = this.createVolume("volume10", 100, 10);
        node.addVolume(volume10);
        node.addVolume(volume20);
        node.addVolume(volume30);
        nullConnector.addNode(node);
        cluster.readClusterInfo();
        Assert.assertEquals((long)1L, (long)cluster.getNodes().size());
        GreedyPlanner planner = new GreedyPlanner(5.0, node);
        NodePlan plan = new NodePlan(node.getDataNodeUUID(), node.getDataNodePort());
        planner.balanceVolumeSet(node, (DiskBalancerVolumeSet)node.getVolumeSets().get("SSD"), plan);
        Assert.assertEquals((long)1L, (long)plan.getVolumeSetPlans().size());
        Step step = (Step)plan.getVolumeSetPlans().get(0);
        Assert.assertEquals((Object)"volume30", (Object)step.getSourceVolume().getPath());
        Assert.assertEquals((Object)"volume10", (Object)step.getDestinationVolume().getPath());
        Assert.assertEquals((Object)"10 G", (Object)step.getSizeString(step.getBytesToMove()));
    }

    @Test
    public void testGreedyPlannerEqualDisksNoMoves() throws Exception {
        NullConnector nullConnector = new NullConnector();
        DiskBalancerCluster cluster = new DiskBalancerCluster((ClusterConnector)nullConnector);
        DiskBalancerDataNode node = new DiskBalancerDataNode(UUID.randomUUID().toString());
        DiskBalancerVolume volume1 = this.createVolume("volume1", 100, 30);
        DiskBalancerVolume volume2 = this.createVolume("volume2", 100, 30);
        DiskBalancerVolume volume3 = this.createVolume("volume3", 100, 30);
        node.addVolume(volume1);
        node.addVolume(volume2);
        node.addVolume(volume3);
        nullConnector.addNode(node);
        cluster.readClusterInfo();
        Assert.assertEquals((long)1L, (long)cluster.getNodes().size());
        GreedyPlanner planner = new GreedyPlanner(10.0, node);
        NodePlan plan = new NodePlan(node.getDataNodeName(), node.getDataNodePort());
        planner.balanceVolumeSet(node, (DiskBalancerVolumeSet)node.getVolumeSets().get("SSD"), plan);
        Assert.assertEquals((long)0L, (long)plan.getVolumeSetPlans().size());
    }

    @Test
    public void testGreedyPlannerMoveFromSingleDisk() throws Exception {
        NullConnector nullConnector = new NullConnector();
        DiskBalancerCluster cluster = new DiskBalancerCluster((ClusterConnector)nullConnector);
        DiskBalancerDataNode node = new DiskBalancerDataNode(UUID.randomUUID().toString());
        DiskBalancerVolume volume1 = this.createVolume("volume100", 200, 100);
        DiskBalancerVolume volume2 = this.createVolume("volume0-1", 200, 0);
        DiskBalancerVolume volume3 = this.createVolume("volume0-2", 200, 0);
        node.addVolume(volume1);
        node.addVolume(volume2);
        node.addVolume(volume3);
        nullConnector.addNode(node);
        cluster.readClusterInfo();
        Assert.assertEquals((long)1L, (long)cluster.getNodes().size());
        GreedyPlanner planner = new GreedyPlanner(10.0, node);
        NodePlan plan = new NodePlan(node.getDataNodeName(), node.getDataNodePort());
        planner.balanceVolumeSet(node, (DiskBalancerVolumeSet)node.getVolumeSets().get("SSD"), plan);
        Assert.assertEquals((long)2L, (long)plan.getVolumeSetPlans().size());
        Step step = (Step)plan.getVolumeSetPlans().get(0);
        Assert.assertEquals((Object)"volume100", (Object)step.getSourceVolume().getPath());
        Assert.assertTrue((boolean)step.getSizeString(step.getBytesToMove()).matches("33.[2|3|4] G"));
        step = (Step)plan.getVolumeSetPlans().get(1);
        Assert.assertEquals((Object)"volume100", (Object)step.getSourceVolume().getPath());
        Assert.assertTrue((boolean)step.getSizeString(step.getBytesToMove()).matches("33.[2|3|4] G"));
    }

    @Test
    public void testGreedyPlannerThresholdTest() throws Exception {
        NullConnector nullConnector = new NullConnector();
        DiskBalancerCluster cluster = new DiskBalancerCluster((ClusterConnector)nullConnector);
        DiskBalancerDataNode node = new DiskBalancerDataNode(UUID.randomUUID().toString());
        DiskBalancerVolume volume1 = this.createVolume("volume100", 1000, 100);
        DiskBalancerVolume volume2 = this.createVolume("volume0-1", 300, 0);
        DiskBalancerVolume volume3 = this.createVolume("volume0-2", 300, 0);
        node.addVolume(volume1);
        node.addVolume(volume2);
        node.addVolume(volume3);
        nullConnector.addNode(node);
        cluster.readClusterInfo();
        Assert.assertEquals((long)1L, (long)cluster.getNodes().size());
        GreedyPlanner planner = new GreedyPlanner(10.0, node);
        NodePlan plan = new NodePlan(node.getDataNodeName(), node.getDataNodePort());
        planner.balanceVolumeSet(node, (DiskBalancerVolumeSet)node.getVolumeSets().get("SSD"), plan);
        Assert.assertEquals((long)0L, (long)plan.getVolumeSetPlans().size());
        GreedyPlanner newPlanner = new GreedyPlanner(1.0, node);
        NodePlan newPlan = new NodePlan(node.getDataNodeName(), node.getDataNodePort());
        newPlanner.balanceVolumeSet(node, (DiskBalancerVolumeSet)node.getVolumeSets().get("SSD"), newPlan);
        Assert.assertEquals((long)2L, (long)newPlan.getVolumeSetPlans().size());
        Step step = (Step)newPlan.getVolumeSetPlans().get(0);
        Assert.assertEquals((Object)"volume100", (Object)step.getSourceVolume().getPath());
        Assert.assertTrue((boolean)step.getSizeString(step.getBytesToMove()).matches("18.[6|7|8] G"));
        step = (Step)newPlan.getVolumeSetPlans().get(1);
        Assert.assertEquals((Object)"volume100", (Object)step.getSourceVolume().getPath());
        Assert.assertTrue((boolean)step.getSizeString(step.getBytesToMove()).matches("18.[6|7|8] G"));
    }

    @Test
    public void testGreedyPlannerPlanWithDifferentDiskSizes() throws Exception {
        NullConnector nullConnector = new NullConnector();
        DiskBalancerCluster cluster = new DiskBalancerCluster((ClusterConnector)nullConnector);
        DiskBalancerDataNode node = new DiskBalancerDataNode(UUID.randomUUID().toString());
        DiskBalancerVolume volume1 = this.createVolume("volume100", 1000, 100);
        DiskBalancerVolume volume2 = this.createVolume("volume0-1", 500, 0);
        DiskBalancerVolume volume3 = this.createVolume("volume0-2", 250, 0);
        node.addVolume(volume1);
        node.addVolume(volume2);
        node.addVolume(volume3);
        nullConnector.addNode(node);
        cluster.readClusterInfo();
        Assert.assertEquals((long)1L, (long)cluster.getNodes().size());
        GreedyPlanner newPlanner = new GreedyPlanner(1.0, node);
        NodePlan newPlan = new NodePlan(node.getDataNodeName(), node.getDataNodePort());
        newPlanner.balanceVolumeSet(node, (DiskBalancerVolumeSet)node.getVolumeSets().get("SSD"), newPlan);
        Assert.assertEquals((long)2L, (long)newPlan.getVolumeSetPlans().size());
        for (Step step : newPlan.getVolumeSetPlans()) {
            if (step.getDestinationVolume().getPath().equals("volume0-1")) {
                Assert.assertEquals((Object)"volume100", (Object)step.getSourceVolume().getPath());
                Assert.assertEquals((Object)"28.5 G", (Object)step.getSizeString(step.getBytesToMove()));
            }
            if (!step.getDestinationVolume().getPath().equals("volume0-2")) continue;
            Assert.assertEquals((Object)"volume100", (Object)step.getSourceVolume().getPath());
            Assert.assertEquals((Object)"14.3 G", (Object)step.getSizeString(step.getBytesToMove()));
        }
        Step step = (Step)newPlan.getVolumeSetPlans().get(0);
        Assert.assertEquals((double)0.05714f, (double)step.getIdealStorage(), (double)0.001f);
    }

    @Test
    public void testLoadsCorrectClusterConnector() throws Exception {
        ClusterConnector connector = ConnectorFactory.getCluster((URI)this.getClass().getResource("/diskBalancer/data-cluster-3node-3disk.json").toURI(), null);
        Assert.assertEquals((Object)connector.getClass().toString(), (Object)"class org.apache.hadoop.hdfs.server.diskbalancer.connectors.JsonNodeConnector");
    }

    @Test
    public void testPlannerScale() throws Exception {
        int diskCount = 256;
        DiskBalancerTestUtil util = new DiskBalancerTestUtil();
        DiskBalancerVolumeSet vSet = util.createRandomVolumeSet(StorageType.SSD, 256);
        NullConnector nullConnector = new NullConnector();
        DiskBalancerCluster cluster = new DiskBalancerCluster((ClusterConnector)nullConnector);
        DiskBalancerDataNode node = new DiskBalancerDataNode(UUID.randomUUID().toString());
        int diskNum = 0;
        for (DiskBalancerVolume vol : vSet.getVolumes()) {
            vol.setPath("volume" + diskNum++);
            node.addVolume(vol);
        }
        nullConnector.addNode(node);
        cluster.readClusterInfo();
        GreedyPlanner newPlanner = new GreedyPlanner(1.0, node);
        NodePlan newPlan = new NodePlan(node.getDataNodeName(), node.getDataNodePort());
        newPlanner.balanceVolumeSet(node, (DiskBalancerVolumeSet)node.getVolumeSets().get("SSD"), newPlan);
        Assert.assertTrue((String)"No Steps Generated from random disks, very unlikely", (newPlan.getVolumeSetPlans().size() > 0 ? 1 : 0) != 0);
        Assert.assertTrue((String)"Steps Generated less than disk count - false", (newPlan.getVolumeSetPlans().size() < 256 ? 1 : 0) != 0);
        LOG.info("Number of steps are : %d%n", (Object)newPlan.getVolumeSetPlans().size());
    }

    @Test
    public void testNodePlanSerialize() throws Exception {
        int diskCount = 12;
        DiskBalancerTestUtil util = new DiskBalancerTestUtil();
        DiskBalancerVolumeSet vSet = util.createRandomVolumeSet(StorageType.SSD, 12);
        NullConnector nullConnector = new NullConnector();
        DiskBalancerCluster cluster = new DiskBalancerCluster((ClusterConnector)nullConnector);
        DiskBalancerDataNode node = new DiskBalancerDataNode(UUID.randomUUID().toString());
        int diskNum = 0;
        for (DiskBalancerVolume vol : vSet.getVolumes()) {
            vol.setPath("volume" + diskNum++);
            node.addVolume(vol);
        }
        nullConnector.addNode(node);
        cluster.readClusterInfo();
        GreedyPlanner newPlanner = new GreedyPlanner(1.0, node);
        NodePlan newPlan = new NodePlan(node.getDataNodeName(), node.getDataNodePort());
        newPlanner.balanceVolumeSet(node, (DiskBalancerVolumeSet)node.getVolumeSets().get("SSD"), newPlan);
        String planString = newPlan.toJson();
        Assert.assertNotNull((Object)planString);
        NodePlan copy = NodePlan.parseJson((String)planString);
        Assert.assertNotNull((Object)copy);
        Assert.assertEquals((long)newPlan.getVolumeSetPlans().size(), (long)copy.getVolumeSetPlans().size());
    }

    @Test
    public void testGreedyPlannerLargeDisksWithData() throws Exception {
        NullConnector nullConnector = new NullConnector();
        DiskBalancerCluster cluster = new DiskBalancerCluster((ClusterConnector)nullConnector);
        DiskBalancerDataNode node = new DiskBalancerDataNode(UUID.randomUUID().toString());
        DiskBalancerVolume volume1 = this.createVolume("volume1", 1968, 88);
        DiskBalancerVolume volume2 = this.createVolume("volume2", 1968, 88);
        DiskBalancerVolume volume3 = this.createVolume("volume3", 1968, 111);
        DiskBalancerVolume volume4 = this.createVolume("volume4", 1968, 111);
        DiskBalancerVolume volume5 = this.createVolume("volume5", 1968, 30);
        DiskBalancerVolume volume6 = this.createVolume("volume6", 1563, 30);
        DiskBalancerVolume volume7 = this.createVolume("volume7", 1563, 30);
        DiskBalancerVolume volume8 = this.createVolume("volume8", 1563, 30);
        DiskBalancerVolume volume9 = this.createVolume("volume9", 1563, 210);
        node.addVolume(volume1);
        node.addVolume(volume2);
        node.addVolume(volume3);
        node.addVolume(volume4);
        node.addVolume(volume5);
        node.addVolume(volume6);
        node.addVolume(volume7);
        node.addVolume(volume8);
        node.addVolume(volume9);
        nullConnector.addNode(node);
        cluster.readClusterInfo();
        Assert.assertEquals((long)1L, (long)cluster.getNodes().size());
        GreedyPlanner planner = new GreedyPlanner(1.0, node);
        NodePlan plan = new NodePlan(node.getDataNodeName(), node.getDataNodePort());
        planner.balanceVolumeSet(node, (DiskBalancerVolumeSet)node.getVolumeSets().get("SSD"), plan);
        Assert.assertTrue((plan.getVolumeSetPlans().size() > 2 ? 1 : 0) != 0);
    }
}

