/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.datanode.metrics;

import java.io.IOException;
import org.apache.hadoop.hdfs.server.datanode.metrics.FSDatasetMBean;
import org.apache.hadoop.metrics2.MetricsCollector;
import org.apache.hadoop.metrics2.MetricsTag;
import org.apache.hadoop.metrics2.lib.Interns;

public class DataNodeMetricHelper {
    public static void getMetrics(MetricsCollector collector, FSDatasetMBean beanClass, String context) throws IOException {
        if (beanClass == null) {
            throw new IOException("beanClass cannot be null");
        }
        String className = beanClass.getClass().getName();
        collector.addRecord(className).setContext(context).addGauge(Interns.info((String)"Capacity", (String)"Total storage capacity"), beanClass.getCapacity()).addGauge(Interns.info((String)"DfsUsed", (String)"Total bytes used by dfs datanode"), beanClass.getDfsUsed()).addGauge(Interns.info((String)"Remaining", (String)"Total bytes of free storage"), beanClass.getRemaining()).add(new MetricsTag(Interns.info((String)"StorageInfo", (String)"Storage ID"), beanClass.getStorageInfo())).addGauge(Interns.info((String)"NumFailedVolumes", (String)"Number of failed Volumes in the data Node"), beanClass.getNumFailedVolumes()).addGauge(Interns.info((String)"LastVolumeFailureDate", (String)"Last Volume failure in milliseconds from epoch"), beanClass.getLastVolumeFailureDate()).addGauge(Interns.info((String)"EstimatedCapacityLostTotal", (String)"Total capacity lost due to volume failure"), beanClass.getEstimatedCapacityLostTotal()).addGauge(Interns.info((String)"CacheUsed", (String)"Datanode cache used in bytes"), beanClass.getCacheUsed()).addGauge(Interns.info((String)"CacheCapacity", (String)"Datanode cache capacity"), beanClass.getCacheCapacity()).addGauge(Interns.info((String)"NumBlocksCached", (String)"Datanode number of blocks cached"), beanClass.getNumBlocksCached()).addGauge(Interns.info((String)"NumBlocksFailedToCache", (String)"Datanode number of blocks failed to cache"), beanClass.getNumBlocksFailedToCache()).addGauge(Interns.info((String)"NumBlocksFailedToUnCache", (String)"Datanode number of blocks failed in cache eviction"), beanClass.getNumBlocksFailedToUncache()).addGauge(Interns.info((String)"LastDirectoryScannerFinishTime", (String)"Finish time of the last directory scan"), beanClass.getLastDirScannerFinishTime()).addGauge(Interns.info((String)"PendingAsyncDeletions", (String)"The count of pending and running asynchronous disk operations"), beanClass.getPendingAsyncDeletions());
    }
}

