/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.matrix.store;

import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import org.ojalgo.access.Access1D;
import org.ojalgo.concurrent.DaemonPoolExecutor;
import org.ojalgo.matrix.store.ElementsConsumer;
import org.ojalgo.matrix.store.LogicalStore;
import org.ojalgo.matrix.store.MatrixStore;

abstract class DelegatingStore<N extends Number>
extends LogicalStore<N> {
    protected DelegatingStore(MatrixStore<N> base, int rowsCount, int columnsCount) {
        super(base, rowsCount, columnsCount);
    }

    @Override
    public void supplyTo(ElementsConsumer<N> receiver) {
        this.addNonzerosTo(receiver);
    }

    protected final Future<MatrixStore<N>> executeMultiplyLeftOnBase(Access1D<N> left) {
        return DaemonPoolExecutor.invoke(new MultiplyLeft(this.getBase(), left));
    }

    protected final Future<MatrixStore<N>> executeMultiplyRightOnBase(MatrixStore<N> right) {
        return DaemonPoolExecutor.invoke(new MultiplyRight(this.getBase(), right));
    }

    private static final class MultiplyRight<N extends Number>
    implements Callable<MatrixStore<N>> {
        private MatrixStore<N> myRightStore;
        private MatrixStore<N> myThisStore;

        public MultiplyRight(MatrixStore<N> thisStore, MatrixStore<N> rightStore) {
            this.myThisStore = thisStore;
            this.myRightStore = rightStore;
        }

        private MultiplyRight() {
            this(null, null);
        }

        @Override
        public MatrixStore<N> call() throws Exception {
            return this.myThisStore.multiply(this.myRightStore);
        }
    }

    private static final class MultiplyLeft<N extends Number>
    implements Callable<MatrixStore<N>> {
        private Access1D<N> myLeftStore;
        private MatrixStore<N> myThisStore;

        public MultiplyLeft(MatrixStore<N> thisStore, Access1D<N> leftStore) {
            this.myThisStore = thisStore;
            this.myLeftStore = leftStore;
        }

        private MultiplyLeft() {
            this(null, null);
        }

        @Override
        public MatrixStore<N> call() throws Exception {
            return ((MatrixStore)this.myLeftStore).multiply(this.myThisStore);
        }
    }
}

