/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.scalar;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.MathContext;
import org.ojalgo.constant.PrimitiveMath;
import org.ojalgo.function.PrimitiveFunction;
import org.ojalgo.scalar.BigScalar;
import org.ojalgo.scalar.Scalar;
import org.ojalgo.type.TypeUtils;
import org.ojalgo.type.context.NumberContext;

final class RationalNumber2
extends Number
implements Scalar<RationalNumber2>,
NumberContext.Enforceable<RationalNumber2> {
    public static final Scalar.Factory<RationalNumber2> FACTORY = new Scalar.Factory<RationalNumber2>(){

        @Override
        public RationalNumber2 cast(double value) {
            return RationalNumber2.valueOf(value);
        }

        @Override
        public RationalNumber2 cast(Number number) {
            return RationalNumber2.valueOf(number);
        }

        public RationalNumber2 convert(double value) {
            return RationalNumber2.valueOf(value);
        }

        public RationalNumber2 convert(Number number) {
            return RationalNumber2.valueOf(number);
        }

        public RationalNumber2 one() {
            return ONE;
        }

        public RationalNumber2 zero() {
            return ZERO;
        }
    };
    public static final RationalNumber2 NaN = new RationalNumber2(0L, 0L);
    public static final RationalNumber2 NEG = new RationalNumber2(-1L, 1L);
    public static final RationalNumber2 NEGATIVE_INFINITY = new RationalNumber2(-1L, 0L);
    public static final RationalNumber2 ONE = new RationalNumber2(1L, 1L);
    public static final RationalNumber2 POSITIVE_INFINITY = new RationalNumber2(1L, 0L);
    public static final RationalNumber2 TWO = new RationalNumber2(2L, 1L);
    public static final RationalNumber2 ZERO = new RationalNumber2(0L, 1L);
    private static final String DIVIDE = " / ";
    private static final String LEFT = "(";
    private static final String RIGHT = ")";
    private static final long LIMIT = Math.round(Math.sqrt(9.223372036854776E18));
    private transient BigDecimal myDecimal = null;
    private final long myDenominator;
    private final long myNumerator;

    public static BigInteger gcd(BigInteger value1, BigInteger value2) {
        return value1.gcd(value2);
    }

    public static int gcd(int value1, int value2) {
        int retVal = 1;
        value1 = Math.abs(value1);
        value2 = Math.abs(value2);
        int tmpMax = Math.max(value1, value2);
        int tmpMin = Math.min(value1, value2);
        while (tmpMin != 0) {
            retVal = tmpMin;
            tmpMin = tmpMax % tmpMin;
            tmpMax = retVal;
        }
        return retVal;
    }

    public static long gcd(long value1, long value2) {
        long retVal = 1L;
        value1 = Math.abs(value1);
        value2 = Math.abs(value2);
        long tmpMax = Math.max(value1, value2);
        long tmpMin = Math.min(value1, value2);
        while (tmpMin != 0L) {
            retVal = tmpMin;
            tmpMin = tmpMax % tmpMin;
            tmpMax = retVal;
        }
        return retVal;
    }

    public static boolean isAbsolute(RationalNumber2 value) {
        return value.isAbsolute();
    }

    public static boolean isInfinite(RationalNumber2 value) {
        return value.getNumerator() != 0L && value.getDenominator() == 0L;
    }

    public static boolean isNaN(RationalNumber2 value) {
        return value.getNumerator() == 0L && value.getDenominator() == 0L;
    }

    public static boolean isSmall(double comparedTo, RationalNumber2 value) {
        return value.isSmall(comparedTo);
    }

    public static RationalNumber2 of(long numerator, long denominator) {
        if (numerator == 0L) {
            return new RationalNumber2(numerator, 1L);
        }
        long tmpGCD = RationalNumber2.gcd(numerator, denominator);
        if (tmpGCD != 1L) {
            return new RationalNumber2(numerator / tmpGCD, denominator / tmpGCD);
        }
        if (denominator > LIMIT) {
            tmpGCD = Math.round(PrimitiveFunction.SQRT.invoke(denominator));
            return new RationalNumber2(numerator / tmpGCD, denominator / tmpGCD);
        }
        return new RationalNumber2(numerator, denominator);
    }

    public static RationalNumber2 valueOf(double value) {
        long significand;
        if (Double.isNaN(value)) {
            return NaN;
        }
        if (value == Double.POSITIVE_INFINITY) {
            return POSITIVE_INFINITY;
        }
        if (value == Double.NEGATIVE_INFINITY) {
            return NEGATIVE_INFINITY;
        }
        long valBits = Double.doubleToLongBits(value);
        int sign = valBits >> 63 == 0L ? 1 : -1;
        int exponent = (int)(valBits >> 52 & 0x7FFL);
        long l = significand = exponent == 0 ? (valBits & 0xFFFFFFFFFFFFFL) << 1 : valBits & 0xFFFFFFFFFFFFFL | 0x10000000000000L;
        if ((exponent -= 1075) < 0) {
            return RationalNumber2.of((long)sign * significand, 1L << exponent);
        }
        return RationalNumber2.of((long)sign * significand * (1L << exponent), 1L);
    }

    public static RationalNumber2 valueOf(Number number) {
        if (number != null) {
            BigInteger tmpDenominator;
            BigInteger tmpNumerator;
            if (number instanceof RationalNumber2) {
                return (RationalNumber2)number;
            }
            BigDecimal tmpBigDecimal = TypeUtils.toBigDecimal(number);
            int tmpScale = tmpBigDecimal.scale();
            if (tmpScale < 0) {
                tmpNumerator = tmpBigDecimal.unscaledValue().multiply(BigInteger.TEN.pow(-tmpScale));
                tmpDenominator = BigInteger.ONE;
            } else {
                BigInteger tmpDenom;
                BigInteger tmpNumer = tmpBigDecimal.unscaledValue();
                BigInteger tmpGCD = tmpNumer.gcd(tmpDenom = BigInteger.TEN.pow(tmpScale));
                if (tmpGCD.compareTo(BigInteger.ONE) == 1) {
                    tmpNumerator = tmpNumer.divide(tmpGCD);
                    tmpDenominator = tmpDenom.divide(tmpGCD);
                } else {
                    tmpNumerator = tmpNumer;
                    tmpDenominator = tmpDenom;
                }
            }
            return new RationalNumber2(tmpNumerator.longValue(), tmpDenominator.longValue());
        }
        return ZERO;
    }

    private static String toString(RationalNumber2 aNmbr) {
        StringBuilder retVal = new StringBuilder(LEFT);
        retVal.append(aNmbr.getNumerator());
        retVal.append(DIVIDE);
        retVal.append(aNmbr.getDenominator());
        return retVal.append(RIGHT).toString();
    }

    private RationalNumber2() {
        this(0L, 1L);
    }

    private RationalNumber2(long numerator, long denominator) {
        if (denominator < 0L) {
            throw new IllegalArgumentException();
        }
        if (denominator > LIMIT) {
            throw new IllegalArgumentException();
        }
        this.myNumerator = numerator;
        this.myDenominator = denominator;
    }

    @Override
    public RationalNumber2 add(double arg) {
        return this.add(RationalNumber2.valueOf(arg));
    }

    @Override
    public RationalNumber2 add(RationalNumber2 arg) {
        if (this.myDenominator == arg.getDenominator()) {
            return new RationalNumber2(this.myNumerator + arg.getNumerator(), this.myDenominator);
        }
        long tmpNumer = this.myNumerator * arg.getDenominator() + arg.getNumerator() * this.myDenominator;
        long tmpDenom = this.myDenominator * arg.getDenominator();
        return RationalNumber2.of(tmpNumer, tmpDenom);
    }

    @Override
    public int compareTo(RationalNumber2 reference) {
        return this.toBigDecimal().compareTo(reference.toBigDecimal());
    }

    @Override
    public RationalNumber2 conjugate() {
        return this;
    }

    @Override
    public RationalNumber2 divide(double arg) {
        return this.divide(RationalNumber2.valueOf(arg));
    }

    @Override
    public RationalNumber2 divide(RationalNumber2 arg) {
        long tmpNumer = this.myNumerator * arg.getDenominator();
        long tmpDenom = this.myDenominator * arg.getNumerator();
        return RationalNumber2.of(tmpNumer, tmpDenom);
    }

    @Override
    public double doubleValue() {
        return this.toBigDecimal().doubleValue();
    }

    @Override
    public RationalNumber2 enforce(NumberContext context) {
        return RationalNumber2.valueOf(this.toBigDecimal(context.getMathContext()));
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RationalNumber2)) {
            return false;
        }
        RationalNumber2 other = (RationalNumber2)obj;
        if (this.myDenominator != other.myDenominator) {
            return false;
        }
        return this.myNumerator == other.myNumerator;
    }

    @Override
    public float floatValue() {
        return this.toBigDecimal().floatValue();
    }

    @Override
    public RationalNumber2 getNumber() {
        return this;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (int)(this.myDenominator ^ this.myDenominator >>> 32);
        result = 31 * result + (int)(this.myNumerator ^ this.myNumerator >>> 32);
        return result;
    }

    @Override
    public int intValue() {
        return this.toBigDecimal().intValue();
    }

    @Override
    public RationalNumber2 invert() {
        return new RationalNumber2(this.myDenominator, this.myNumerator);
    }

    @Override
    public boolean isAbsolute() {
        return this.myNumerator >= 0L;
    }

    @Override
    public boolean isSmall(double comparedTo) {
        return BigScalar.CONTEXT.isSmall(comparedTo, this.doubleValue());
    }

    @Override
    public long longValue() {
        return this.toBigDecimal().longValue();
    }

    @Override
    public RationalNumber2 multiply(double arg) {
        return this.multiply(RationalNumber2.valueOf(arg));
    }

    @Override
    public RationalNumber2 multiply(RationalNumber2 arg) {
        long tmpNumer = this.myNumerator * arg.getNumerator();
        long tmpDenom = this.myDenominator * arg.getDenominator();
        return RationalNumber2.of(tmpNumer, tmpDenom);
    }

    @Override
    public RationalNumber2 negate() {
        return new RationalNumber2(-this.myNumerator, this.myDenominator);
    }

    @Override
    public double norm() {
        return PrimitiveFunction.ABS.invoke(this.doubleValue());
    }

    @Override
    public RationalNumber2 signum() {
        if (RationalNumber2.isSmall(PrimitiveMath.ONE, this)) {
            return ZERO;
        }
        if (this.sign() == -1) {
            return ONE.negate();
        }
        return ONE;
    }

    @Override
    public RationalNumber2 subtract(double arg) {
        return this.subtract(RationalNumber2.valueOf(arg));
    }

    @Override
    public RationalNumber2 subtract(RationalNumber2 arg) {
        if (this.myDenominator == arg.getDenominator()) {
            return new RationalNumber2(this.myNumerator - arg.getNumerator(), this.myDenominator);
        }
        long tmpNumer = this.myNumerator * arg.getDenominator() - arg.getNumerator() * this.myDenominator;
        long tmpDenom = this.myDenominator * arg.getDenominator();
        return RationalNumber2.of(tmpNumer, tmpDenom);
    }

    @Override
    public BigDecimal toBigDecimal() {
        if (this.myDecimal == null) {
            this.myDecimal = this.toBigDecimal(BigScalar.CONTEXT.getMathContext());
        }
        return this.myDecimal;
    }

    public String toString() {
        return RationalNumber2.toString(this);
    }

    @Override
    public String toString(NumberContext context) {
        return RationalNumber2.toString(this.enforce(context));
    }

    private int sign() {
        if (this.myNumerator < 0L) {
            return -1;
        }
        if (this.myNumerator > 0L) {
            return 1;
        }
        return 0;
    }

    private BigDecimal toBigDecimal(MathContext context) {
        return new BigDecimal(this.myNumerator).divide(new BigDecimal(this.myDenominator), context);
    }

    long getDenominator() {
        return this.myDenominator;
    }

    long getNumerator() {
        return this.myNumerator;
    }
}

