/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.s3.analyticsaccelerator.request;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import lombok.Generated;
import lombok.NonNull;
import software.amazon.s3.analyticsaccelerator.request.Range;
import software.amazon.s3.analyticsaccelerator.request.Referrer;
import software.amazon.s3.analyticsaccelerator.util.S3URI;

@SuppressFBWarnings(value={"NM_CONFUSING"}, justification="Sharing Getter names is not confusing")
public final class GetRequest {
    @NonNull
    private final S3URI s3Uri;
    @NonNull
    private final Range range;
    @NonNull
    private final Referrer referrer;
    @NonNull
    private final String etag;

    @Generated
    GetRequest(@NonNull S3URI s3Uri, @NonNull Range range, @NonNull Referrer referrer, @NonNull String etag) {
        if (s3Uri == null) {
            throw new NullPointerException("s3Uri is marked non-null but is null");
        }
        if (range == null) {
            throw new NullPointerException("range is marked non-null but is null");
        }
        if (referrer == null) {
            throw new NullPointerException("referrer is marked non-null but is null");
        }
        if (etag == null) {
            throw new NullPointerException("etag is marked non-null but is null");
        }
        this.s3Uri = s3Uri;
        this.range = range;
        this.referrer = referrer;
        this.etag = etag;
    }

    @Generated
    public static GetRequestBuilder builder() {
        return new GetRequestBuilder();
    }

    @NonNull
    @Generated
    public S3URI getS3Uri() {
        return this.s3Uri;
    }

    @NonNull
    @Generated
    public Range getRange() {
        return this.range;
    }

    @NonNull
    @Generated
    public Referrer getReferrer() {
        return this.referrer;
    }

    @NonNull
    @Generated
    public String getEtag() {
        return this.etag;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof GetRequest)) {
            return false;
        }
        GetRequest other = (GetRequest)o;
        S3URI this$s3Uri = this.getS3Uri();
        S3URI other$s3Uri = other.getS3Uri();
        if (this$s3Uri == null ? other$s3Uri != null : !((Object)this$s3Uri).equals(other$s3Uri)) {
            return false;
        }
        Range this$range = this.getRange();
        Range other$range = other.getRange();
        if (this$range == null ? other$range != null : !((Object)this$range).equals(other$range)) {
            return false;
        }
        Referrer this$referrer = this.getReferrer();
        Referrer other$referrer = other.getReferrer();
        if (this$referrer == null ? other$referrer != null : !((Object)this$referrer).equals(other$referrer)) {
            return false;
        }
        String this$etag = this.getEtag();
        String other$etag = other.getEtag();
        return !(this$etag == null ? other$etag != null : !this$etag.equals(other$etag));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        S3URI $s3Uri = this.getS3Uri();
        result = result * 59 + ($s3Uri == null ? 43 : ((Object)$s3Uri).hashCode());
        Range $range = this.getRange();
        result = result * 59 + ($range == null ? 43 : ((Object)$range).hashCode());
        Referrer $referrer = this.getReferrer();
        result = result * 59 + ($referrer == null ? 43 : ((Object)$referrer).hashCode());
        String $etag = this.getEtag();
        result = result * 59 + ($etag == null ? 43 : $etag.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "GetRequest(s3Uri=" + this.getS3Uri() + ", range=" + this.getRange() + ", referrer=" + this.getReferrer() + ", etag=" + this.getEtag() + ")";
    }

    @Generated
    public static class GetRequestBuilder {
        @Generated
        private S3URI s3Uri;
        @Generated
        private Range range;
        @Generated
        private Referrer referrer;
        @Generated
        private String etag;

        @Generated
        GetRequestBuilder() {
        }

        @Generated
        public GetRequestBuilder s3Uri(@NonNull S3URI s3Uri) {
            if (s3Uri == null) {
                throw new NullPointerException("s3Uri is marked non-null but is null");
            }
            this.s3Uri = s3Uri;
            return this;
        }

        @Generated
        public GetRequestBuilder range(@NonNull Range range) {
            if (range == null) {
                throw new NullPointerException("range is marked non-null but is null");
            }
            this.range = range;
            return this;
        }

        @Generated
        public GetRequestBuilder referrer(@NonNull Referrer referrer) {
            if (referrer == null) {
                throw new NullPointerException("referrer is marked non-null but is null");
            }
            this.referrer = referrer;
            return this;
        }

        @Generated
        public GetRequestBuilder etag(@NonNull String etag) {
            if (etag == null) {
                throw new NullPointerException("etag is marked non-null but is null");
            }
            this.etag = etag;
            return this;
        }

        @Generated
        public GetRequest build() {
            return new GetRequest(this.s3Uri, this.range, this.referrer, this.etag);
        }

        @Generated
        public String toString() {
            return "GetRequest.GetRequestBuilder(s3Uri=" + this.s3Uri + ", range=" + this.range + ", referrer=" + this.referrer + ", etag=" + this.etag + ")";
        }
    }
}

