/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.s3.shaded.parquet.org.apache.thrift.protocol;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.IntFunction;
import software.amazon.s3.shaded.parquet.org.apache.thrift.TException;
import software.amazon.s3.shaded.parquet.org.apache.thrift.partial.TFieldData;
import software.amazon.s3.shaded.parquet.org.apache.thrift.protocol.TField;
import software.amazon.s3.shaded.parquet.org.apache.thrift.protocol.TList;
import software.amazon.s3.shaded.parquet.org.apache.thrift.protocol.TMap;
import software.amazon.s3.shaded.parquet.org.apache.thrift.protocol.TMessage;
import software.amazon.s3.shaded.parquet.org.apache.thrift.protocol.TProtocolException;
import software.amazon.s3.shaded.parquet.org.apache.thrift.protocol.TReadProtocol;
import software.amazon.s3.shaded.parquet.org.apache.thrift.protocol.TSet;
import software.amazon.s3.shaded.parquet.org.apache.thrift.protocol.TStruct;
import software.amazon.s3.shaded.parquet.org.apache.thrift.protocol.TWriteProtocol;
import software.amazon.s3.shaded.parquet.org.apache.thrift.scheme.IScheme;
import software.amazon.s3.shaded.parquet.org.apache.thrift.scheme.StandardScheme;
import software.amazon.s3.shaded.parquet.org.apache.thrift.transport.TTransport;

public abstract class TProtocol
implements TWriteProtocol,
TReadProtocol {
    protected TTransport trans_;
    static final int MAX_SKIPPED_BYTES = 256;
    protected byte[] skippedBytes = new byte[256];

    private TProtocol() {
    }

    protected TProtocol(TTransport trans) {
        this.trans_ = trans;
    }

    public TTransport getTransport() {
        return this.trans_;
    }

    protected void checkReadBytesAvailable(TMap map) throws TException {
        long elemSize = this.getMinSerializedSize(map.keyType) + this.getMinSerializedSize(map.valueType);
        this.trans_.checkReadBytesAvailable((long)map.size * elemSize);
    }

    protected void checkReadBytesAvailable(TList list) throws TException {
        long size = list.getSize();
        this.trans_.checkReadBytesAvailable(size * (long)this.getMinSerializedSize(list.elemType));
    }

    protected void checkReadBytesAvailable(TSet set) throws TException {
        long size = set.getSize();
        this.trans_.checkReadBytesAvailable(size * (long)this.getMinSerializedSize(set.elemType));
    }

    public abstract int getMinSerializedSize(byte var1) throws TException;

    public final <T> void writeSet(byte elementType, Set<T> set, WriteCallback<T> callback) throws TException {
        this.writeSetBegin(new TSet(elementType, set.size()));
        for (T t : set) {
            callback.call(t);
        }
        this.writeSetEnd();
    }

    public final <T> void writeList(byte elementType, List<T> list, WriteCallback<T> callback) throws TException {
        this.writeListBegin(new TList(elementType, list.size()));
        for (T t : list) {
            callback.call(t);
        }
        this.writeListEnd();
    }

    public final <K, V> void writeMap(byte keyType, byte valueType, Map<K, V> map, WriteCallback<Map.Entry<K, V>> callback) throws TException {
        this.writeMapBegin(new TMap(keyType, valueType, map.size()));
        for (Map.Entry<K, V> entry : map.entrySet()) {
            callback.call(entry);
        }
        this.writeMapEnd();
    }

    public final void writeField(TField field, WriteCallback<Void> callback) throws TException {
        this.writeFieldBegin(field);
        callback.call(null);
        this.writeFieldEnd();
    }

    public final void writeStruct(TStruct struct, WriteCallback<Void> callback) throws TException {
        this.writeStructBegin(struct);
        callback.call(null);
        this.writeStructEnd();
    }

    public final void writeMessage(TMessage message, WriteCallback<Void> callback) throws TException {
        this.writeMessageBegin(message);
        callback.call(null);
        this.writeMessageEnd();
    }

    public final <T> T readMessage(ReadCallback<TMessage, T> callback) throws TException {
        TMessage tMessage = this.readMessageBegin();
        T t = callback.accept(tMessage);
        this.readMessageEnd();
        return t;
    }

    public final <T> T readStruct(ReadCallback<TStruct, T> callback) throws TException {
        TStruct tStruct = this.readStructBegin();
        T t = callback.accept(tStruct);
        this.readStructEnd();
        return t;
    }

    public final <T> boolean readField(ReadCallback<TField, T> callback) throws Exception {
        TField tField = this.readFieldBegin();
        if (tField.type == 0) {
            return true;
        }
        callback.accept(tField);
        this.readFieldEnd();
        return false;
    }

    public final <T extends Map<?, ?>> T readMap(ReadCallback<TMap, T> callback) throws TException {
        TMap tMap = this.readMapBegin();
        Map t = (Map)callback.accept(tMap);
        this.readMapEnd();
        return (T)t;
    }

    public final <K, V> Map<K, V> readMap(ReadMapEntryCallback<K, V> callback) throws TException {
        return this.readMap(callback, HashMap::new);
    }

    public final <K, V> Map<K, V> readMap(ReadMapEntryCallback<K, V> callback, IntFunction<Map<K, V>> mapCreator) throws TException {
        return this.readMap((TMap tMap) -> {
            Map map = (Map)mapCreator.apply(tMap.size);
            for (int i = 0; i < tMap.size; ++i) {
                map.put(callback.getKey(), callback.getValue());
            }
            return map;
        });
    }

    public final <T extends List<?>> T readList(ReadCallback<TList, T> callback) throws TException {
        TList tList = this.readListBegin();
        List t = (List)callback.accept(tList);
        this.readListEnd();
        return (T)t;
    }

    public final <T> List<T> readList(ReadCollectionCallback<T> callback) throws TException {
        return this.readList(callback, ArrayList::new);
    }

    public final <T> List<T> readList(ReadCollectionCallback<T> callback, IntFunction<List<T>> listCreator) throws TException {
        return this.readList((TList tList) -> {
            List list = (List)listCreator.apply(tList.size);
            for (int i = 0; i < tList.size; ++i) {
                list.add(callback.call());
            }
            return list;
        });
    }

    public final <T extends Set<?>> T readSet(ReadCallback<TSet, T> callback) throws TException {
        TSet tSet = this.readSetBegin();
        Set t = (Set)callback.accept(tSet);
        this.readSetEnd();
        return (T)t;
    }

    public final <T> Set<T> readSet(ReadCollectionCallback<T> callback) throws TException {
        return this.readSet(callback, HashSet::new);
    }

    public final <T> Set<T> readSet(ReadCollectionCallback<T> callback, IntFunction<Set<T>> setCreator) throws TException {
        return this.readSet((TSet tSet) -> {
            Set set = (Set)setCreator.apply(tSet.size);
            for (int i = 0; i < tSet.size; ++i) {
                set.add(callback.call());
            }
            return set;
        });
    }

    public void reset() {
    }

    public Class<? extends IScheme> getScheme() {
        return StandardScheme.class;
    }

    public int readFieldBeginData() throws TException {
        TField tfield = this.readFieldBegin();
        return TFieldData.encode(tfield.type, tfield.id);
    }

    public void skip(byte fieldType) throws TException {
        this.skip(fieldType, Integer.MAX_VALUE);
    }

    public void skip(byte fieldType, int maxDepth) throws TException {
        if (maxDepth <= 0) {
            throw new TException("Maximum skip depth exceeded");
        }
        switch (fieldType) {
            case 2: {
                this.skipBool();
                break;
            }
            case 3: {
                this.skipByte();
                break;
            }
            case 6: {
                this.skipI16();
                break;
            }
            case 8: {
                this.skipI32();
                break;
            }
            case 10: {
                this.skipI64();
                break;
            }
            case 4: {
                this.skipDouble();
                break;
            }
            case 11: {
                this.skipBinary();
                break;
            }
            case 12: {
                int tfieldData;
                byte tfieldType;
                this.readStructBegin();
                while ((tfieldType = TFieldData.getType(tfieldData = this.readFieldBeginData())) != 0) {
                    this.skip(tfieldType, maxDepth - 1);
                    this.readFieldEnd();
                }
                this.readStructEnd();
                break;
            }
            case 13: {
                TMap map = this.readMapBegin();
                for (int i = 0; i < map.size; ++i) {
                    this.skip(map.keyType, maxDepth - 1);
                    this.skip(map.valueType, maxDepth - 1);
                }
                this.readMapEnd();
                break;
            }
            case 14: {
                TSet set = this.readSetBegin();
                for (int i = 0; i < set.size; ++i) {
                    this.skip(set.elemType, maxDepth - 1);
                }
                this.readSetEnd();
                break;
            }
            case 15: {
                TList list = this.readListBegin();
                for (int i = 0; i < list.size; ++i) {
                    this.skip(list.elemType, maxDepth - 1);
                }
                this.readListEnd();
                break;
            }
            default: {
                throw new TProtocolException(1, "Unrecognized type " + fieldType);
            }
        }
    }

    protected void skipBool() throws TException {
        this.readBool();
    }

    protected void skipByte() throws TException {
        this.readByte();
    }

    protected void skipI16() throws TException {
        this.readI16();
    }

    protected void skipI32() throws TException {
        this.readI32();
    }

    protected void skipI64() throws TException {
        this.readI64();
    }

    protected void skipDouble() throws TException {
        this.readDouble();
    }

    protected void skipBinary() throws TException {
        this.readBinary();
    }

    protected void skipBytes(int numBytes) throws TException {
        if (numBytes <= 256) {
            if (this.getTransport().getBytesRemainingInBuffer() >= numBytes) {
                this.getTransport().consumeBuffer(numBytes);
            } else {
                this.getTransport().readAll(this.skippedBytes, 0, numBytes);
            }
        } else {
            for (int remaining = numBytes; remaining > 0; remaining -= 256) {
                this.skipBytes(Math.min(remaining, 256));
            }
        }
    }

    public static interface WriteCallback<T> {
        public void call(T var1) throws TException;
    }

    public static interface ReadCallback<T, R> {
        public R accept(T var1) throws TException;
    }

    public static interface ReadMapEntryCallback<K, V> {
        public K getKey() throws TException;

        public V getValue() throws TException;
    }

    public static interface ReadCollectionCallback<R> {
        public R call() throws TException;
    }
}

