/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapred;

import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.LocalFileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.compress.CompressionCodec;
import org.apache.hadoop.io.compress.GzipCodec;
import org.apache.hadoop.mapred.IFile;
import org.junit.Assert;
import org.junit.Test;

public class TestIFile {
    @Test
    public void testIFileWriterWithCodec() throws Exception {
        Configuration conf = new Configuration();
        LocalFileSystem localFs = FileSystem.getLocal((Configuration)conf);
        FileSystem rfs = localFs.getRaw();
        Path path = new Path(new Path("build/test.ifile"), "data");
        GzipCodec codec = new GzipCodec();
        codec.setConf(conf);
        IFile.Writer writer = new IFile.Writer(conf, rfs.create(path), Text.class, Text.class, (CompressionCodec)codec, null);
        writer.close();
    }

    @Test
    public void testIFileReaderWithCodec() throws Exception {
        Configuration conf = new Configuration();
        LocalFileSystem localFs = FileSystem.getLocal((Configuration)conf);
        FileSystem rfs = localFs.getRaw();
        Path path = new Path(new Path("build/test.ifile"), "data");
        GzipCodec codec = new GzipCodec();
        codec.setConf(conf);
        FSDataOutputStream out = rfs.create(path);
        IFile.Writer writer = new IFile.Writer(conf, out, Text.class, Text.class, (CompressionCodec)codec, null);
        writer.close();
        FSDataInputStream in = rfs.open(path);
        IFile.Reader reader = new IFile.Reader(conf, in, rfs.getFileStatus(path).getLen(), (CompressionCodec)codec, null);
        reader.close();
        byte[] ab = new byte[100];
        int readed = reader.checksumIn.readWithChecksum(ab, 0, ab.length);
        Assert.assertEquals((long)readed, (long)reader.checksumIn.getChecksum().length);
    }
}

