/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.federation.cache;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.shaded.org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.hadoop.shaded.org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.exceptions.YarnException;
import org.apache.hadoop.yarn.server.federation.store.FederationStateStore;
import org.apache.hadoop.yarn.server.federation.store.records.ApplicationHomeSubCluster;
import org.apache.hadoop.yarn.server.federation.store.records.GetApplicationHomeSubClusterRequest;
import org.apache.hadoop.yarn.server.federation.store.records.GetApplicationHomeSubClusterResponse;
import org.apache.hadoop.yarn.server.federation.store.records.GetSubClusterPoliciesConfigurationsRequest;
import org.apache.hadoop.yarn.server.federation.store.records.GetSubClusterPoliciesConfigurationsResponse;
import org.apache.hadoop.yarn.server.federation.store.records.GetSubClustersInfoRequest;
import org.apache.hadoop.yarn.server.federation.store.records.GetSubClustersInfoResponse;
import org.apache.hadoop.yarn.server.federation.store.records.SubClusterId;
import org.apache.hadoop.yarn.server.federation.store.records.SubClusterInfo;
import org.apache.hadoop.yarn.server.federation.store.records.SubClusterPolicyConfiguration;

public abstract class FederationCache {
    protected static final String GET_SUBCLUSTERS_CACHEID = "getSubClusters";
    protected static final String GET_POLICIES_CONFIGURATIONS_CACHEID = "getPoliciesConfigurations";
    protected static final String GET_APPLICATION_HOME_SUBCLUSTER_CACHEID = "getApplicationHomeSubCluster";
    protected static final String POINT = ".";
    private FederationStateStore stateStore;

    public abstract boolean isCachingEnabled();

    public abstract void initCache(Configuration var1, FederationStateStore var2);

    public abstract void clearCache();

    protected String buildCacheKey(String className, String methodName) {
        return this.buildCacheKey(className, methodName, null);
    }

    protected String buildCacheKey(String className, String methodName, String argName) {
        StringBuilder buffer = new StringBuilder();
        buffer.append(className).append(POINT).append(methodName);
        if (argName != null) {
            buffer.append(POINT);
            buffer.append(argName);
        }
        return buffer.toString();
    }

    public abstract Map<SubClusterId, SubClusterInfo> getSubClusters(boolean var1) throws YarnException;

    public abstract Map<String, SubClusterPolicyConfiguration> getPoliciesConfigurations() throws Exception;

    public abstract SubClusterId getApplicationHomeSubCluster(ApplicationId var1) throws Exception;

    public abstract void removeSubCluster(boolean var1);

    protected CacheRequest<String, CacheResponse<SubClusterInfo>> buildGetSubClustersCacheRequest(String cacheKey, boolean filterInactiveSubClusters) throws YarnException {
        CacheResponse<SubClusterInfo> response = this.buildSubClusterInfoResponse(filterInactiveSubClusters);
        CacheRequest<String, CacheResponse<SubClusterInfo>> cacheRequest = new CacheRequest<String, CacheResponse<SubClusterInfo>>(cacheKey, response);
        return cacheRequest;
    }

    private CacheResponse<SubClusterInfo> buildSubClusterInfoResponse(boolean filterInactiveSubClusters) throws YarnException {
        GetSubClustersInfoRequest request = GetSubClustersInfoRequest.newInstance(filterInactiveSubClusters);
        GetSubClustersInfoResponse subClusters = this.stateStore.getSubClusters(request);
        SubClusterInfoCacheResponse response = new SubClusterInfoCacheResponse();
        ((CacheResponse)response).setList(subClusters.getSubClusters());
        return response;
    }

    public static Map<SubClusterId, SubClusterInfo> buildSubClusterInfoMap(GetSubClustersInfoResponse response) {
        List<SubClusterInfo> subClusters = response.getSubClusters();
        return FederationCache.buildSubClusterInfoMap(subClusters);
    }

    public static Map<SubClusterId, SubClusterInfo> buildSubClusterInfoMap(CacheRequest<String, ?> cacheRequest) {
        Object value = ((CacheRequest)cacheRequest).value;
        SubClusterInfoCacheResponse response = (SubClusterInfoCacheResponse)SubClusterInfoCacheResponse.class.cast(value);
        List<SubClusterInfo> subClusters = response.getList();
        return FederationCache.buildSubClusterInfoMap(subClusters);
    }

    private static Map<SubClusterId, SubClusterInfo> buildSubClusterInfoMap(List<SubClusterInfo> subClusters) {
        HashMap<SubClusterId, SubClusterInfo> subClustersMap = new HashMap<SubClusterId, SubClusterInfo>(subClusters.size());
        for (SubClusterInfo subCluster : subClusters) {
            subClustersMap.put(subCluster.getSubClusterId(), subCluster);
        }
        return subClustersMap;
    }

    protected CacheRequest<String, CacheResponse<SubClusterId>> buildGetApplicationHomeSubClusterRequest(String cacheKey, ApplicationId applicationId) throws YarnException {
        CacheResponse<SubClusterId> response = this.buildSubClusterIdResponse(applicationId);
        return new CacheRequest<String, CacheResponse<SubClusterId>>(cacheKey, response);
    }

    private CacheResponse<SubClusterId> buildSubClusterIdResponse(ApplicationId applicationId) throws YarnException {
        GetApplicationHomeSubClusterRequest request = GetApplicationHomeSubClusterRequest.newInstance(applicationId);
        GetApplicationHomeSubClusterResponse response = this.stateStore.getApplicationHomeSubCluster(request);
        ApplicationHomeSubCluster appHomeSubCluster = response.getApplicationHomeSubCluster();
        SubClusterId subClusterId = appHomeSubCluster.getHomeSubCluster();
        ApplicationHomeSubClusterCacheResponse cacheResponse = new ApplicationHomeSubClusterCacheResponse();
        ((CacheResponse)cacheResponse).setItem(subClusterId);
        return cacheResponse;
    }

    protected CacheRequest<String, CacheResponse<SubClusterPolicyConfiguration>> buildGetPoliciesConfigurationsCacheRequest(String cacheKey) throws YarnException {
        CacheResponse<SubClusterPolicyConfiguration> response = this.buildSubClusterPolicyConfigurationResponse();
        return new CacheRequest<String, CacheResponse<SubClusterPolicyConfiguration>>(cacheKey, response);
    }

    public static Map<String, SubClusterPolicyConfiguration> buildPolicyConfigMap(GetSubClusterPoliciesConfigurationsResponse response) {
        List<SubClusterPolicyConfiguration> policyConfigs = response.getPoliciesConfigs();
        return FederationCache.buildPolicyConfigMap(policyConfigs);
    }

    private static Map<String, SubClusterPolicyConfiguration> buildPolicyConfigMap(List<SubClusterPolicyConfiguration> policyConfigs) {
        HashMap<String, SubClusterPolicyConfiguration> queuePolicyConfigs = new HashMap<String, SubClusterPolicyConfiguration>();
        for (SubClusterPolicyConfiguration policyConfig : policyConfigs) {
            queuePolicyConfigs.put(policyConfig.getQueue(), policyConfig);
        }
        return queuePolicyConfigs;
    }

    public static Map<String, SubClusterPolicyConfiguration> buildPolicyConfigMap(CacheRequest<String, ?> cacheRequest) {
        Object value = ((CacheRequest)cacheRequest).value;
        SubClusterPolicyConfigurationCacheResponse response = (SubClusterPolicyConfigurationCacheResponse)SubClusterPolicyConfigurationCacheResponse.class.cast(value);
        List<SubClusterPolicyConfiguration> subClusters = response.getList();
        return FederationCache.buildPolicyConfigMap(subClusters);
    }

    private CacheResponse<SubClusterPolicyConfiguration> buildSubClusterPolicyConfigurationResponse() throws YarnException {
        GetSubClusterPoliciesConfigurationsRequest request = GetSubClusterPoliciesConfigurationsRequest.newInstance();
        GetSubClusterPoliciesConfigurationsResponse response = this.stateStore.getPoliciesConfigurations(request);
        List<SubClusterPolicyConfiguration> policyConfigs = response.getPoliciesConfigs();
        SubClusterPolicyConfigurationCacheResponse cacheResponse = new SubClusterPolicyConfigurationCacheResponse();
        ((CacheResponse)cacheResponse).setList(policyConfigs);
        return cacheResponse;
    }

    public FederationStateStore getStateStore() {
        return this.stateStore;
    }

    public void setStateStore(FederationStateStore stateStore) {
        this.stateStore = stateStore;
    }

    public class ApplicationHomeSubClusterCacheResponse
    extends CacheResponse<SubClusterId> {
        @Override
        public List<SubClusterId> getList() {
            return super.getList();
        }

        @Override
        public void setList(List<SubClusterId> list) {
            super.setList(list);
        }

        @Override
        public SubClusterId getItem() {
            return (SubClusterId)super.getItem();
        }

        @Override
        public void setItem(SubClusterId item) {
            super.setItem(item);
        }
    }

    public class SubClusterPolicyConfigurationCacheResponse
    extends CacheResponse<SubClusterPolicyConfiguration> {
        @Override
        public List<SubClusterPolicyConfiguration> getList() {
            return super.getList();
        }

        @Override
        public void setList(List<SubClusterPolicyConfiguration> list) {
            super.setList(list);
        }

        @Override
        public SubClusterPolicyConfiguration getItem() {
            return (SubClusterPolicyConfiguration)super.getItem();
        }

        @Override
        public void setItem(SubClusterPolicyConfiguration item) {
            super.setItem(item);
        }
    }

    public class SubClusterInfoCacheResponse
    extends CacheResponse<SubClusterInfo> {
        @Override
        public List<SubClusterInfo> getList() {
            return super.getList();
        }

        @Override
        public void setList(List<SubClusterInfo> list) {
            super.setList(list);
        }

        @Override
        public SubClusterInfo getItem() {
            return (SubClusterInfo)super.getItem();
        }

        @Override
        public void setItem(SubClusterInfo item) {
            super.setItem(item);
        }
    }

    public class CacheResponse<R> {
        private List<R> list;
        private R item;

        public List<R> getList() {
            return this.list;
        }

        public void setList(List<R> list) {
            this.list = list;
        }

        public R getItem() {
            return this.item;
        }

        public void setItem(R pItem) {
            this.item = pItem;
        }
    }

    public class CacheRequest<K, V> {
        private K key;
        private V value;

        CacheRequest(K pKey, V pValue) {
            this.key = pKey;
            this.value = pValue;
        }

        public V getValue() throws Exception {
            return this.value;
        }

        public int hashCode() {
            return new HashCodeBuilder().append(this.key).toHashCode();
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (obj instanceof CacheRequest) {
                Class<CacheRequest> cacheRequestClass = CacheRequest.class;
                CacheRequest other = (CacheRequest)cacheRequestClass.cast(obj);
                return new EqualsBuilder().append(this.key, other.key).isEquals();
            }
            return false;
        }
    }
}

