/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.core5.testing.framework;

import java.util.Map;
import org.apache.hc.core5.testing.framework.ClientPOJOAdapter;
import org.apache.hc.core5.testing.framework.TestingFrameworkException;
import org.apache.hc.core5.testing.framework.TestingFrameworkRequestHandler;

public class ClientTestingAdapter {
    protected ClientPOJOAdapter adapter;
    protected boolean callAssertNothingThrown;

    public ClientTestingAdapter() {
    }

    public ClientTestingAdapter(ClientPOJOAdapter adapter) {
        this.adapter = adapter;
    }

    public Map<String, Object> execute(String defaultURI, Map<String, Object> request, TestingFrameworkRequestHandler requestHandler, Map<String, Object> responseExpectations) throws TestingFrameworkException {
        try {
            if (this.adapter == null) {
                throw new TestingFrameworkException("adapter cannot be null");
            }
            Map<String, Object> response = this.adapter.execute(defaultURI, request);
            if (this.callAssertNothingThrown) {
                if (requestHandler == null) {
                    throw new TestingFrameworkException("requestHandler cannot be null");
                }
                requestHandler.assertNothingThrown();
            }
            return response;
        }
        catch (TestingFrameworkException e) {
            throw e;
        }
        catch (Exception ex) {
            throw new TestingFrameworkException(ex);
        }
    }

    public boolean isRequestSupported(Map<String, Object> request) {
        return this.adapter == null || this.adapter.checkRequestSupport(request) == null;
    }

    public Map<String, Object> modifyRequest(Map<String, Object> request) {
        return this.adapter == null ? request : this.adapter.modifyRequest(request);
    }

    public Map<String, Object> modifyResponseExpectations(Map<String, Object> request, Map<String, Object> responseExpectations) {
        return responseExpectations;
    }

    public ClientPOJOAdapter getClientPOJOAdapter() {
        return this.adapter;
    }
}

