/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.core5.http.examples;

import java.util.concurrent.TimeUnit;
import org.apache.hc.core5.http.ClassicHttpRequest;
import org.apache.hc.core5.http.ClassicHttpResponse;
import org.apache.hc.core5.http.HttpConnection;
import org.apache.hc.core5.http.HttpEntity;
import org.apache.hc.core5.http.HttpHost;
import org.apache.hc.core5.http.HttpRequest;
import org.apache.hc.core5.http.HttpResponse;
import org.apache.hc.core5.http.impl.Http1StreamListener;
import org.apache.hc.core5.http.impl.bootstrap.HttpRequester;
import org.apache.hc.core5.http.impl.bootstrap.RequesterBootstrap;
import org.apache.hc.core5.http.io.SocketConfig;
import org.apache.hc.core5.http.io.entity.EntityUtils;
import org.apache.hc.core5.http.io.support.ClassicRequestBuilder;
import org.apache.hc.core5.http.message.RequestLine;
import org.apache.hc.core5.http.message.StatusLine;
import org.apache.hc.core5.http.protocol.HttpContext;
import org.apache.hc.core5.http.protocol.HttpCoreContext;
import org.apache.hc.core5.util.Timeout;

public class ClassicGetExecutionExample {
    public static void main(String[] args) throws Exception {
        HttpRequester httpRequester = RequesterBootstrap.bootstrap().setStreamListener(new Http1StreamListener(){

            public void onRequestHead(HttpConnection connection, HttpRequest request) {
                System.out.println(connection.getRemoteAddress() + " " + new RequestLine(request));
            }

            public void onResponseHead(HttpConnection connection, HttpResponse response) {
                System.out.println(connection.getRemoteAddress() + " " + new StatusLine(response));
            }

            public void onExchangeComplete(HttpConnection connection, boolean keepAlive) {
                if (keepAlive) {
                    System.out.println(connection.getRemoteAddress() + " exchange completed (connection kept alive)");
                } else {
                    System.out.println(connection.getRemoteAddress() + " exchange completed (connection closed)");
                }
            }
        }).setSocketConfig(SocketConfig.custom().setSoTimeout(5, TimeUnit.SECONDS).build()).create();
        HttpCoreContext context = HttpCoreContext.create();
        HttpHost target = new HttpHost("httpbin.org");
        String[] requestUris = new String[]{"/", "/ip", "/user-agent", "/headers"};
        for (int i = 0; i < requestUris.length; ++i) {
            String requestUri = requestUris[i];
            ClassicHttpRequest request = ClassicRequestBuilder.get().setHttpHost(target).setPath(requestUri).build();
            try (ClassicHttpResponse response = httpRequester.execute(target, request, Timeout.ofSeconds((long)5L), (HttpContext)context);){
                System.out.println(requestUri + "->" + response.getCode());
                System.out.println(EntityUtils.toString((HttpEntity)response.getEntity()));
                System.out.println("==============");
                continue;
            }
        }
    }
}

