/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package org.apache.tiles.core.evaluator;

import org.apache.tiles.api.Attribute;

/**
 * Creates an attribute evaluator using the language or an attribute.
 *
 * @since 2.2.0
 */
public interface AttributeEvaluatorFactory {

    /**
     * Creates and attribute evaluator using an attribute.
     *
     * @param attribute The attribute used to obtain the evaluator.
     * @return The attribute evaluator. It must not be <code>null</code>.
     * @since 2.2.0
     */
    AttributeEvaluator getAttributeEvaluator(Attribute attribute);

    /**
     * Creates and attribute evaluator for the given expression language.
     *
     * @param language The name of the expression language.
     * @return The attribute evaluator. It must not be <code>null</code>.
     * @since 2.2.0
     */
    AttributeEvaluator getAttributeEvaluator(String language);
}
