/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.resource;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.wicket.javascript.IJavaScriptCompressor;
import org.apache.wicket.resource.CompositeCssCompressor;
import org.apache.wicket.resource.IScopeAwareTextResourceProcessor;

public class CompositeJavaScriptCompressor
implements IScopeAwareTextResourceProcessor,
IJavaScriptCompressor {
    private final List<IJavaScriptCompressor> compressors = new ArrayList<IJavaScriptCompressor>();

    public CompositeJavaScriptCompressor(IJavaScriptCompressor ... compressors) {
        this.compressors.addAll(Arrays.asList(compressors));
    }

    @Override
    public String process(String input, Class<?> scope, String name) {
        String compressed = input;
        for (IJavaScriptCompressor compressor : this.compressors) {
            if (compressor instanceof IScopeAwareTextResourceProcessor) {
                IScopeAwareTextResourceProcessor processor = (IScopeAwareTextResourceProcessor)((Object)compressor);
                compressed = processor.process(compressed, scope, name);
                continue;
            }
            compressed = compressor.compress(compressed);
        }
        return compressed;
    }

    @Override
    public String compress(String original) {
        throw new UnsupportedOperationException(CompositeCssCompressor.class.getSimpleName() + ".process() should be used instead!");
    }

    public CompositeJavaScriptCompressor add(IJavaScriptCompressor compressor) {
        this.compressors.add(compressor);
        return this;
    }
}

