/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.markup.html.image;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.wicket.markup.ComponentTag;
import org.apache.wicket.markup.html.CrossOrigin;
import org.apache.wicket.markup.html.WebComponent;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;

public class ExternalImage
extends WebComponent {
    private static final long serialVersionUID = 1L;
    private List<String> xValues = null;
    private List<String> sizes = null;
    private CrossOrigin crossOrigin = null;
    private IModel<List<Serializable>> srcSetModel;

    public ExternalImage(String id) {
        this(id, null, Model.ofList(Collections.emptyList()));
    }

    public ExternalImage(String id, Serializable src) {
        this(id, Model.of(src), Model.ofList(Collections.emptyList()));
    }

    public ExternalImage(String id, Serializable src, List<Serializable> srcSet) {
        this(id, Model.of(src), Model.ofList(srcSet));
    }

    public ExternalImage(String id, IModel<Serializable> srcModel) {
        this(id, srcModel, Model.ofList(Collections.emptyList()));
    }

    public ExternalImage(String id, IModel<Serializable> srcModel, IModel<List<Serializable>> srcSetModel) {
        super(id, srcModel);
        this.srcSetModel = srcSetModel;
    }

    @Override
    protected void onComponentTag(ComponentTag tag) {
        super.onComponentTag(tag);
        if ("source".equals(tag.getName())) {
            this.buildSrcSetAttribute(tag, this.getSrcSetModel());
        } else {
            this.checkComponentTag(tag, "img");
            this.buildSrcAttribute(tag, this.getDefaultModel());
            this.buildSrcSetAttribute(tag, this.getSrcSetModel());
        }
        this.buildSizesAttribute(tag);
        CrossOrigin crossOrigin = this.getCrossOrigin();
        if (crossOrigin != null && CrossOrigin.NO_CORS != crossOrigin) {
            tag.put("crossOrigin", crossOrigin.getRealName());
        }
    }

    protected void buildSrcAttribute(ComponentTag tag, IModel<?> srcModel) {
        tag.put("src", String.valueOf(srcModel.getObject()));
    }

    protected void buildSrcSetAttribute(ComponentTag tag, IModel<List<Serializable>> srcSetModel) {
        int srcSetPosition = 0;
        List<Serializable> srcSetItems = srcSetModel.getObject();
        for (Serializable srcSet : srcSetItems) {
            String srcset = tag.getAttribute("srcset");
            String xValue = "";
            if (this.xValues != null) {
                xValue = this.xValues.size() > srcSetPosition && this.xValues.get(srcSetPosition) != null ? " " + this.xValues.get(srcSetPosition) : "";
            }
            tag.put("srcset", (String)(srcset != null ? srcset + ", " : "") + String.valueOf(srcSet) + xValue);
            ++srcSetPosition;
        }
    }

    protected void buildSizesAttribute(ComponentTag tag) {
        if (this.sizes == null) {
            return;
        }
        Object sizes = "";
        for (String size : this.sizes) {
            sizes = (String)sizes + size + ",";
        }
        int lastIndexOf = ((String)sizes).lastIndexOf(",");
        if (lastIndexOf != -1) {
            sizes = ((String)sizes).substring(0, lastIndexOf);
        }
        if (!((String)sizes).isEmpty()) {
            tag.put("sizes", (CharSequence)sizes);
        }
    }

    public void setXValues(String ... values) {
        if (this.xValues == null) {
            this.xValues = new ArrayList<String>();
        } else {
            this.xValues.clear();
        }
        this.xValues.addAll(Arrays.asList(values));
    }

    public void removeSizes() {
        if (this.sizes != null) {
            this.sizes.clear();
        }
    }

    public void setSizes(String ... sizes) {
        if (this.sizes == null) {
            this.sizes = new ArrayList<String>();
        } else {
            this.sizes.clear();
        }
        this.sizes.addAll(Arrays.asList(sizes));
    }

    public void removeXValues() {
        if (this.xValues != null) {
            this.xValues.clear();
        }
    }

    public CrossOrigin getCrossOrigin() {
        return this.crossOrigin;
    }

    public void setCrossOrigin(CrossOrigin crossOrigin) {
        this.crossOrigin = crossOrigin;
    }

    public IModel<List<Serializable>> getSrcSetModel() {
        return this.srcSetModel;
    }

    public void setSrcSetModel(IModel<List<Serializable>> srcSetModel) {
        this.srcSetModel = srcSetModel;
    }

    @Override
    protected void onDetach() {
        if (this.srcSetModel != null) {
            this.srcSetModel.detach();
        }
        super.onDetach();
    }
}

