/* $Id: Item.hpp 421067 2013-12-09 16:23:08Z ucko $
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 */

/// @file Item.hpp
/// User-defined methods of the data storage class.
///
/// This file was originally generated by application DATATOOL
/// using the following specifications:
/// 'esummary.dtd'.
///
/// New methods or data members can be added to it if needed.
/// See also: Item_.hpp


#ifndef esummary__OBJTOOLS_EUTILS_ESUMMARY_ITEM_HPP
#define esummary__OBJTOOLS_EUTILS_ESUMMARY_ITEM_HPP


// generated includes
#include <objtools/eutils/esummary/Item_.hpp>

// generated classes

BEGIN_esummary_SCOPE // namespace esummary::

NCBI_USING_NAMESPACE_STD;

/////////////////////////////////////////////////////////////////////////////
class NCBI_EUTILS_EXPORT CItem : public CItem_Base
{
    typedef CItem_Base Tparent;
public:
    // constructor
    CItem(void);
    // destructor
    ~CItem(void);

    /// Get item name from the attributes or empty string.
    const string& GetName(void) const;

    /// Get string value of the item. Returns the first _CharData from the
    /// sub-items or null if there are no sub-items of type _CharData.
    const string& GetValue(void) const;

    /// If the item has sub-items, return string value for the key or empty
    /// string if the key does not exist in the sub-items. If the sub-item
    /// contains multiple strings for the key, only the first one is returned.
    const string& FindValue(const string& key) const;

    /// If the item has sub-items, return sub-item for the key or NULL if the
    /// key does not exist in the sub-items. If there are multiple items for
    /// the key, only the first one is returned.
    const CItem* FindItem(const string& key) const;

private:
    // Prohibit copy constructor and assignment operator
    CItem(const CItem& value);
    CItem& operator=(const CItem& value);

};

/////////////////// CItem inline methods

// constructor
inline
CItem::CItem(void)
{
}


inline
const string& CItem::GetName(void) const
{
    return GetAttlist().GetName();
}


/////////////////// end of CItem inline methods


END_esummary_SCOPE // namespace esummary::


#endif // esummary__OBJTOOLS_EUTILS_ESUMMARY_ITEM_HPP
/* Original file checksum: lines: 82, chars: 2349, CRC32: 63ee6fa6 */
