# pylint: disable=too-many-lines
# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) Python Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
from io import IOBase
import json
import sys
from typing import Any, AsyncIterable, Callable, Dict, IO, List, Optional, TypeVar, Union, overload
import urllib.parse

from azure.core.async_paging import AsyncItemPaged, AsyncList
from azure.core.exceptions import (
    ClientAuthenticationError,
    HttpResponseError,
    ResourceExistsError,
    ResourceNotFoundError,
    ResourceNotModifiedError,
    map_error,
)
from azure.core.pipeline import PipelineResponse
from azure.core.rest import AsyncHttpResponse, HttpRequest
from azure.core.tracing.decorator import distributed_trace
from azure.core.tracing.decorator_async import distributed_trace_async
from azure.core.utils import case_insensitive_dict

from ... import models as _models
from ..._model_base import SdkJSONEncoder, _deserialize
from ..._operations._operations import (
    build_blocklist_add_or_update_blocklist_items_request,
    build_blocklist_create_or_update_text_blocklist_request,
    build_blocklist_delete_text_blocklist_request,
    build_blocklist_get_text_blocklist_item_request,
    build_blocklist_get_text_blocklist_request,
    build_blocklist_list_text_blocklist_items_request,
    build_blocklist_list_text_blocklists_request,
    build_blocklist_remove_blocklist_items_request,
    build_content_safety_analyze_image_request,
    build_content_safety_analyze_text_request,
)
from .._vendor import BlocklistClientMixinABC, ContentSafetyClientMixinABC

if sys.version_info >= (3, 9):
    from collections.abc import MutableMapping
else:
    from typing import MutableMapping  # type: ignore  # pylint: disable=ungrouped-imports
JSON = MutableMapping[str, Any]  # pylint: disable=unsubscriptable-object
T = TypeVar("T")
ClsType = Optional[Callable[[PipelineResponse[HttpRequest, AsyncHttpResponse], T, Dict[str, Any]], Any]]


class ContentSafetyClientOperationsMixin(ContentSafetyClientMixinABC):
    @overload
    async def analyze_text(
        self, options: _models.AnalyzeTextOptions, *, content_type: str = "application/json", **kwargs: Any
    ) -> _models.AnalyzeTextResult:
        """Analyze Text.

        A synchronous API for the analysis of potentially harmful text content. Currently, it supports
        four categories: Hate, SelfHarm, Sexual, and Violence.

        :param options: The text analysis request. Required.
        :type options: ~azure.ai.contentsafety.models.AnalyzeTextOptions
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :keyword bool stream: Whether to stream the response of this operation. Defaults to False. You
         will have to context manage the returned stream.
        :return: AnalyzeTextResult. The AnalyzeTextResult is compatible with MutableMapping
        :rtype: ~azure.ai.contentsafety.models.AnalyzeTextResult
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def analyze_text(
        self, options: JSON, *, content_type: str = "application/json", **kwargs: Any
    ) -> _models.AnalyzeTextResult:
        """Analyze Text.

        A synchronous API for the analysis of potentially harmful text content. Currently, it supports
        four categories: Hate, SelfHarm, Sexual, and Violence.

        :param options: The text analysis request. Required.
        :type options: JSON
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :keyword bool stream: Whether to stream the response of this operation. Defaults to False. You
         will have to context manage the returned stream.
        :return: AnalyzeTextResult. The AnalyzeTextResult is compatible with MutableMapping
        :rtype: ~azure.ai.contentsafety.models.AnalyzeTextResult
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def analyze_text(
        self, options: IO[bytes], *, content_type: str = "application/json", **kwargs: Any
    ) -> _models.AnalyzeTextResult:
        """Analyze Text.

        A synchronous API for the analysis of potentially harmful text content. Currently, it supports
        four categories: Hate, SelfHarm, Sexual, and Violence.

        :param options: The text analysis request. Required.
        :type options: IO[bytes]
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :keyword bool stream: Whether to stream the response of this operation. Defaults to False. You
         will have to context manage the returned stream.
        :return: AnalyzeTextResult. The AnalyzeTextResult is compatible with MutableMapping
        :rtype: ~azure.ai.contentsafety.models.AnalyzeTextResult
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace_async
    async def analyze_text(
        self, options: Union[_models.AnalyzeTextOptions, JSON, IO[bytes]], **kwargs: Any
    ) -> _models.AnalyzeTextResult:
        """Analyze Text.

        A synchronous API for the analysis of potentially harmful text content. Currently, it supports
        four categories: Hate, SelfHarm, Sexual, and Violence.

        :param options: The text analysis request. Is one of the following types: AnalyzeTextOptions,
         JSON, IO[bytes] Required.
        :type options: ~azure.ai.contentsafety.models.AnalyzeTextOptions or JSON or IO[bytes]
        :keyword content_type: Body parameter Content-Type. Known values are: application/json. Default
         value is None.
        :paramtype content_type: str
        :keyword bool stream: Whether to stream the response of this operation. Defaults to False. You
         will have to context manage the returned stream.
        :return: AnalyzeTextResult. The AnalyzeTextResult is compatible with MutableMapping
        :rtype: ~azure.ai.contentsafety.models.AnalyzeTextResult
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[_models.AnalyzeTextResult] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _content = None
        if isinstance(options, (IOBase, bytes)):
            _content = options
        else:
            _content = json.dumps(options, cls=SdkJSONEncoder, exclude_readonly=True)  # type: ignore

        _request = build_content_safety_analyze_text_request(
            content_type=content_type,
            api_version=self._config.api_version,
            content=_content,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = kwargs.pop("stream", False)
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            if _stream:
                await response.read()  # Load the body in memory and close the socket
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if _stream:
            deserialized = response.iter_bytes()
        else:
            deserialized = _deserialize(_models.AnalyzeTextResult, response.json())

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @overload
    async def analyze_image(
        self, options: _models.AnalyzeImageOptions, *, content_type: str = "application/json", **kwargs: Any
    ) -> _models.AnalyzeImageResult:
        """Analyze Image.

        A synchronous API for the analysis of potentially harmful image content. Currently, it supports
        four categories: Hate, SelfHarm, Sexual, and Violence.

        :param options: The image analysis request. Required.
        :type options: ~azure.ai.contentsafety.models.AnalyzeImageOptions
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :keyword bool stream: Whether to stream the response of this operation. Defaults to False. You
         will have to context manage the returned stream.
        :return: AnalyzeImageResult. The AnalyzeImageResult is compatible with MutableMapping
        :rtype: ~azure.ai.contentsafety.models.AnalyzeImageResult
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def analyze_image(
        self, options: JSON, *, content_type: str = "application/json", **kwargs: Any
    ) -> _models.AnalyzeImageResult:
        """Analyze Image.

        A synchronous API for the analysis of potentially harmful image content. Currently, it supports
        four categories: Hate, SelfHarm, Sexual, and Violence.

        :param options: The image analysis request. Required.
        :type options: JSON
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :keyword bool stream: Whether to stream the response of this operation. Defaults to False. You
         will have to context manage the returned stream.
        :return: AnalyzeImageResult. The AnalyzeImageResult is compatible with MutableMapping
        :rtype: ~azure.ai.contentsafety.models.AnalyzeImageResult
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def analyze_image(
        self, options: IO[bytes], *, content_type: str = "application/json", **kwargs: Any
    ) -> _models.AnalyzeImageResult:
        """Analyze Image.

        A synchronous API for the analysis of potentially harmful image content. Currently, it supports
        four categories: Hate, SelfHarm, Sexual, and Violence.

        :param options: The image analysis request. Required.
        :type options: IO[bytes]
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :keyword bool stream: Whether to stream the response of this operation. Defaults to False. You
         will have to context manage the returned stream.
        :return: AnalyzeImageResult. The AnalyzeImageResult is compatible with MutableMapping
        :rtype: ~azure.ai.contentsafety.models.AnalyzeImageResult
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace_async
    async def analyze_image(
        self, options: Union[_models.AnalyzeImageOptions, JSON, IO[bytes]], **kwargs: Any
    ) -> _models.AnalyzeImageResult:
        """Analyze Image.

        A synchronous API for the analysis of potentially harmful image content. Currently, it supports
        four categories: Hate, SelfHarm, Sexual, and Violence.

        :param options: The image analysis request. Is one of the following types: AnalyzeImageOptions,
         JSON, IO[bytes] Required.
        :type options: ~azure.ai.contentsafety.models.AnalyzeImageOptions or JSON or IO[bytes]
        :keyword content_type: Body parameter Content-Type. Known values are: application/json. Default
         value is None.
        :paramtype content_type: str
        :keyword bool stream: Whether to stream the response of this operation. Defaults to False. You
         will have to context manage the returned stream.
        :return: AnalyzeImageResult. The AnalyzeImageResult is compatible with MutableMapping
        :rtype: ~azure.ai.contentsafety.models.AnalyzeImageResult
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[_models.AnalyzeImageResult] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _content = None
        if isinstance(options, (IOBase, bytes)):
            _content = options
        else:
            _content = json.dumps(options, cls=SdkJSONEncoder, exclude_readonly=True)  # type: ignore

        _request = build_content_safety_analyze_image_request(
            content_type=content_type,
            api_version=self._config.api_version,
            content=_content,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = kwargs.pop("stream", False)
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            if _stream:
                await response.read()  # Load the body in memory and close the socket
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if _stream:
            deserialized = response.iter_bytes()
        else:
            deserialized = _deserialize(_models.AnalyzeImageResult, response.json())

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore


class BlocklistClientOperationsMixin(BlocklistClientMixinABC):
    @overload
    async def add_or_update_blocklist_items(
        self,
        blocklist_name: str,
        options: _models.AddOrUpdateTextBlocklistItemsOptions,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.AddOrUpdateTextBlocklistItemsResult:
        """Add or update BlocklistItems To Text Blocklist.

        Add or update blocklistItems to a text blocklist. You can add or update at most 100
        blocklistItems in one request.

        :param blocklist_name: Text blocklist name. Required.
        :type blocklist_name: str
        :param options: Options for adding or updating blocklist items. Required.
        :type options: ~azure.ai.contentsafety.models.AddOrUpdateTextBlocklistItemsOptions
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :keyword bool stream: Whether to stream the response of this operation. Defaults to False. You
         will have to context manage the returned stream.
        :return: AddOrUpdateTextBlocklistItemsResult. The AddOrUpdateTextBlocklistItemsResult is
         compatible with MutableMapping
        :rtype: ~azure.ai.contentsafety.models.AddOrUpdateTextBlocklistItemsResult
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def add_or_update_blocklist_items(
        self, blocklist_name: str, options: JSON, *, content_type: str = "application/json", **kwargs: Any
    ) -> _models.AddOrUpdateTextBlocklistItemsResult:
        """Add or update BlocklistItems To Text Blocklist.

        Add or update blocklistItems to a text blocklist. You can add or update at most 100
        blocklistItems in one request.

        :param blocklist_name: Text blocklist name. Required.
        :type blocklist_name: str
        :param options: Options for adding or updating blocklist items. Required.
        :type options: JSON
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :keyword bool stream: Whether to stream the response of this operation. Defaults to False. You
         will have to context manage the returned stream.
        :return: AddOrUpdateTextBlocklistItemsResult. The AddOrUpdateTextBlocklistItemsResult is
         compatible with MutableMapping
        :rtype: ~azure.ai.contentsafety.models.AddOrUpdateTextBlocklistItemsResult
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def add_or_update_blocklist_items(
        self, blocklist_name: str, options: IO[bytes], *, content_type: str = "application/json", **kwargs: Any
    ) -> _models.AddOrUpdateTextBlocklistItemsResult:
        """Add or update BlocklistItems To Text Blocklist.

        Add or update blocklistItems to a text blocklist. You can add or update at most 100
        blocklistItems in one request.

        :param blocklist_name: Text blocklist name. Required.
        :type blocklist_name: str
        :param options: Options for adding or updating blocklist items. Required.
        :type options: IO[bytes]
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :keyword bool stream: Whether to stream the response of this operation. Defaults to False. You
         will have to context manage the returned stream.
        :return: AddOrUpdateTextBlocklistItemsResult. The AddOrUpdateTextBlocklistItemsResult is
         compatible with MutableMapping
        :rtype: ~azure.ai.contentsafety.models.AddOrUpdateTextBlocklistItemsResult
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace_async
    async def add_or_update_blocklist_items(
        self,
        blocklist_name: str,
        options: Union[_models.AddOrUpdateTextBlocklistItemsOptions, JSON, IO[bytes]],
        **kwargs: Any
    ) -> _models.AddOrUpdateTextBlocklistItemsResult:
        """Add or update BlocklistItems To Text Blocklist.

        Add or update blocklistItems to a text blocklist. You can add or update at most 100
        blocklistItems in one request.

        :param blocklist_name: Text blocklist name. Required.
        :type blocklist_name: str
        :param options: Options for adding or updating blocklist items. Is one of the following types:
         AddOrUpdateTextBlocklistItemsOptions, JSON, IO[bytes] Required.
        :type options: ~azure.ai.contentsafety.models.AddOrUpdateTextBlocklistItemsOptions or JSON or
         IO[bytes]
        :keyword content_type: Body parameter Content-Type. Known values are: application/json. Default
         value is None.
        :paramtype content_type: str
        :keyword bool stream: Whether to stream the response of this operation. Defaults to False. You
         will have to context manage the returned stream.
        :return: AddOrUpdateTextBlocklistItemsResult. The AddOrUpdateTextBlocklistItemsResult is
         compatible with MutableMapping
        :rtype: ~azure.ai.contentsafety.models.AddOrUpdateTextBlocklistItemsResult
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[_models.AddOrUpdateTextBlocklistItemsResult] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _content = None
        if isinstance(options, (IOBase, bytes)):
            _content = options
        else:
            _content = json.dumps(options, cls=SdkJSONEncoder, exclude_readonly=True)  # type: ignore

        _request = build_blocklist_add_or_update_blocklist_items_request(
            blocklist_name=blocklist_name,
            content_type=content_type,
            api_version=self._config.api_version,
            content=_content,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = kwargs.pop("stream", False)
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            if _stream:
                await response.read()  # Load the body in memory and close the socket
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if _stream:
            deserialized = response.iter_bytes()
        else:
            deserialized = _deserialize(_models.AddOrUpdateTextBlocklistItemsResult, response.json())

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @overload
    async def create_or_update_text_blocklist(
        self,
        blocklist_name: str,
        options: _models.TextBlocklist,
        *,
        content_type: str = "application/merge-patch+json",
        **kwargs: Any
    ) -> _models.TextBlocklist:
        """Create Or Update Text Blocklist.

        Updates a text blocklist. If the blocklistName does not exist, a new blocklist will be created.

        :param blocklist_name: Text blocklist name. Required.
        :type blocklist_name: str
        :param options: The resource instance. Required.
        :type options: ~azure.ai.contentsafety.models.TextBlocklist
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/merge-patch+json".
        :paramtype content_type: str
        :keyword bool stream: Whether to stream the response of this operation. Defaults to False. You
         will have to context manage the returned stream.
        :return: TextBlocklist. The TextBlocklist is compatible with MutableMapping
        :rtype: ~azure.ai.contentsafety.models.TextBlocklist
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def create_or_update_text_blocklist(
        self, blocklist_name: str, options: JSON, *, content_type: str = "application/merge-patch+json", **kwargs: Any
    ) -> _models.TextBlocklist:
        """Create Or Update Text Blocklist.

        Updates a text blocklist. If the blocklistName does not exist, a new blocklist will be created.

        :param blocklist_name: Text blocklist name. Required.
        :type blocklist_name: str
        :param options: The resource instance. Required.
        :type options: JSON
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/merge-patch+json".
        :paramtype content_type: str
        :keyword bool stream: Whether to stream the response of this operation. Defaults to False. You
         will have to context manage the returned stream.
        :return: TextBlocklist. The TextBlocklist is compatible with MutableMapping
        :rtype: ~azure.ai.contentsafety.models.TextBlocklist
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def create_or_update_text_blocklist(
        self,
        blocklist_name: str,
        options: IO[bytes],
        *,
        content_type: str = "application/merge-patch+json",
        **kwargs: Any
    ) -> _models.TextBlocklist:
        """Create Or Update Text Blocklist.

        Updates a text blocklist. If the blocklistName does not exist, a new blocklist will be created.

        :param blocklist_name: Text blocklist name. Required.
        :type blocklist_name: str
        :param options: The resource instance. Required.
        :type options: IO[bytes]
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/merge-patch+json".
        :paramtype content_type: str
        :keyword bool stream: Whether to stream the response of this operation. Defaults to False. You
         will have to context manage the returned stream.
        :return: TextBlocklist. The TextBlocklist is compatible with MutableMapping
        :rtype: ~azure.ai.contentsafety.models.TextBlocklist
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace_async
    async def create_or_update_text_blocklist(
        self, blocklist_name: str, options: Union[_models.TextBlocklist, JSON, IO[bytes]], **kwargs: Any
    ) -> _models.TextBlocklist:
        """Create Or Update Text Blocklist.

        Updates a text blocklist. If the blocklistName does not exist, a new blocklist will be created.

        :param blocklist_name: Text blocklist name. Required.
        :type blocklist_name: str
        :param options: The resource instance. Is one of the following types: TextBlocklist, JSON,
         IO[bytes] Required.
        :type options: ~azure.ai.contentsafety.models.TextBlocklist or JSON or IO[bytes]
        :keyword content_type: This request has a JSON Merge Patch body. Default value is None.
        :paramtype content_type: str
        :keyword bool stream: Whether to stream the response of this operation. Defaults to False. You
         will have to context manage the returned stream.
        :return: TextBlocklist. The TextBlocklist is compatible with MutableMapping
        :rtype: ~azure.ai.contentsafety.models.TextBlocklist
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[_models.TextBlocklist] = kwargs.pop("cls", None)

        content_type = content_type or "application/merge-patch+json"
        _content = None
        if isinstance(options, (IOBase, bytes)):
            _content = options
        else:
            _content = json.dumps(options, cls=SdkJSONEncoder, exclude_readonly=True)  # type: ignore

        _request = build_blocklist_create_or_update_text_blocklist_request(
            blocklist_name=blocklist_name,
            content_type=content_type,
            api_version=self._config.api_version,
            content=_content,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = kwargs.pop("stream", False)
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200, 201]:
            if _stream:
                await response.read()  # Load the body in memory and close the socket
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if response.status_code == 200:
            if _stream:
                deserialized = response.iter_bytes()
            else:
                deserialized = _deserialize(_models.TextBlocklist, response.json())

        if response.status_code == 201:
            if _stream:
                deserialized = response.iter_bytes()
            else:
                deserialized = _deserialize(_models.TextBlocklist, response.json())

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @distributed_trace_async
    async def delete_text_blocklist(  # pylint: disable=inconsistent-return-statements
        self, blocklist_name: str, **kwargs: Any
    ) -> None:
        """Delete Text Blocklist By blocklistName.

        Deletes a text blocklist.

        :param blocklist_name: Text blocklist name. Required.
        :type blocklist_name: str
        :return: None
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[None] = kwargs.pop("cls", None)

        _request = build_blocklist_delete_text_blocklist_request(
            blocklist_name=blocklist_name,
            api_version=self._config.api_version,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [204]:
            if _stream:
                await response.read()  # Load the body in memory and close the socket
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if cls:
            return cls(pipeline_response, None, {})  # type: ignore

    @distributed_trace_async
    async def get_text_blocklist(self, blocklist_name: str, **kwargs: Any) -> _models.TextBlocklist:
        """Get Text Blocklist By blocklistName.

        Returns text blocklist details.

        :param blocklist_name: Text blocklist name. Required.
        :type blocklist_name: str
        :keyword bool stream: Whether to stream the response of this operation. Defaults to False. You
         will have to context manage the returned stream.
        :return: TextBlocklist. The TextBlocklist is compatible with MutableMapping
        :rtype: ~azure.ai.contentsafety.models.TextBlocklist
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[_models.TextBlocklist] = kwargs.pop("cls", None)

        _request = build_blocklist_get_text_blocklist_request(
            blocklist_name=blocklist_name,
            api_version=self._config.api_version,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = kwargs.pop("stream", False)
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            if _stream:
                await response.read()  # Load the body in memory and close the socket
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if _stream:
            deserialized = response.iter_bytes()
        else:
            deserialized = _deserialize(_models.TextBlocklist, response.json())

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @distributed_trace_async
    async def get_text_blocklist_item(
        self, blocklist_name: str, blocklist_item_id: str, **kwargs: Any
    ) -> _models.TextBlocklistItem:
        """Get BlocklistItem By blocklistName And blocklistItemId.

        Get blocklistItem by blocklistName and blocklistItemId from a text blocklist.

        :param blocklist_name: Text blocklist name. Required.
        :type blocklist_name: str
        :param blocklist_item_id: The service will generate a BlocklistItemId, which will be a UUID.
         Required.
        :type blocklist_item_id: str
        :keyword bool stream: Whether to stream the response of this operation. Defaults to False. You
         will have to context manage the returned stream.
        :return: TextBlocklistItem. The TextBlocklistItem is compatible with MutableMapping
        :rtype: ~azure.ai.contentsafety.models.TextBlocklistItem
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[_models.TextBlocklistItem] = kwargs.pop("cls", None)

        _request = build_blocklist_get_text_blocklist_item_request(
            blocklist_name=blocklist_name,
            blocklist_item_id=blocklist_item_id,
            api_version=self._config.api_version,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = kwargs.pop("stream", False)
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            if _stream:
                await response.read()  # Load the body in memory and close the socket
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if _stream:
            deserialized = response.iter_bytes()
        else:
            deserialized = _deserialize(_models.TextBlocklistItem, response.json())

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @distributed_trace
    def list_text_blocklist_items(
        self, blocklist_name: str, *, top: Optional[int] = None, skip: Optional[int] = None, **kwargs: Any
    ) -> AsyncIterable["_models.TextBlocklistItem"]:
        """Get All BlocklistItems By blocklistName.

        Get all blocklistItems in a text blocklist.

        :param blocklist_name: Text blocklist name. Required.
        :type blocklist_name: str
        :keyword top: The number of result items to return. Default value is None.
        :paramtype top: int
        :keyword skip: The number of result items to skip. Default value is None.
        :paramtype skip: int
        :return: An iterator like instance of TextBlocklistItem
        :rtype:
         ~azure.core.async_paging.AsyncItemPaged[~azure.ai.contentsafety.models.TextBlocklistItem]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        maxpagesize = kwargs.pop("maxpagesize", None)
        cls: ClsType[List[_models.TextBlocklistItem]] = kwargs.pop("cls", None)

        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        def prepare_request(next_link=None):
            if not next_link:

                _request = build_blocklist_list_text_blocklist_items_request(
                    blocklist_name=blocklist_name,
                    top=top,
                    skip=skip,
                    maxpagesize=maxpagesize,
                    api_version=self._config.api_version,
                    headers=_headers,
                    params=_params,
                )
                path_format_arguments = {
                    "endpoint": self._serialize.url(
                        "self._config.endpoint", self._config.endpoint, "str", skip_quote=True
                    ),
                }
                _request.url = self._client.format_url(_request.url, **path_format_arguments)

            else:
                # make call to next link with the client's api-version
                _parsed_next_link = urllib.parse.urlparse(next_link)
                _next_request_params = case_insensitive_dict(
                    {
                        key: [urllib.parse.quote(v) for v in value]
                        for key, value in urllib.parse.parse_qs(_parsed_next_link.query).items()
                    }
                )
                _next_request_params["api-version"] = self._config.api_version
                _request = HttpRequest(
                    "GET", urllib.parse.urljoin(next_link, _parsed_next_link.path), params=_next_request_params
                )
                path_format_arguments = {
                    "endpoint": self._serialize.url(
                        "self._config.endpoint", self._config.endpoint, "str", skip_quote=True
                    ),
                }
                _request.url = self._client.format_url(_request.url, **path_format_arguments)

            return _request

        async def extract_data(pipeline_response):
            deserialized = pipeline_response.http_response.json()
            list_of_elem = _deserialize(List[_models.TextBlocklistItem], deserialized["value"])
            if cls:
                list_of_elem = cls(list_of_elem)  # type: ignore
            return deserialized.get("nextLink") or None, AsyncList(list_of_elem)

        async def get_next(next_link=None):
            _request = prepare_request(next_link)

            _stream = False
            pipeline_response: PipelineResponse = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
                _request, stream=_stream, **kwargs
            )
            response = pipeline_response.http_response

            if response.status_code not in [200]:
                if _stream:
                    await response.read()  # Load the body in memory and close the socket
                map_error(status_code=response.status_code, response=response, error_map=error_map)
                raise HttpResponseError(response=response)

            return pipeline_response

        return AsyncItemPaged(get_next, extract_data)

    @distributed_trace
    def list_text_blocklists(self, **kwargs: Any) -> AsyncIterable["_models.TextBlocklist"]:
        """Get All Text Blocklists.

        Get all text blocklists details.

        :return: An iterator like instance of TextBlocklist
        :rtype: ~azure.core.async_paging.AsyncItemPaged[~azure.ai.contentsafety.models.TextBlocklist]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[List[_models.TextBlocklist]] = kwargs.pop("cls", None)

        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        def prepare_request(next_link=None):
            if not next_link:

                _request = build_blocklist_list_text_blocklists_request(
                    api_version=self._config.api_version,
                    headers=_headers,
                    params=_params,
                )
                path_format_arguments = {
                    "endpoint": self._serialize.url(
                        "self._config.endpoint", self._config.endpoint, "str", skip_quote=True
                    ),
                }
                _request.url = self._client.format_url(_request.url, **path_format_arguments)

            else:
                # make call to next link with the client's api-version
                _parsed_next_link = urllib.parse.urlparse(next_link)
                _next_request_params = case_insensitive_dict(
                    {
                        key: [urllib.parse.quote(v) for v in value]
                        for key, value in urllib.parse.parse_qs(_parsed_next_link.query).items()
                    }
                )
                _next_request_params["api-version"] = self._config.api_version
                _request = HttpRequest(
                    "GET", urllib.parse.urljoin(next_link, _parsed_next_link.path), params=_next_request_params
                )
                path_format_arguments = {
                    "endpoint": self._serialize.url(
                        "self._config.endpoint", self._config.endpoint, "str", skip_quote=True
                    ),
                }
                _request.url = self._client.format_url(_request.url, **path_format_arguments)

            return _request

        async def extract_data(pipeline_response):
            deserialized = pipeline_response.http_response.json()
            list_of_elem = _deserialize(List[_models.TextBlocklist], deserialized["value"])
            if cls:
                list_of_elem = cls(list_of_elem)  # type: ignore
            return deserialized.get("nextLink") or None, AsyncList(list_of_elem)

        async def get_next(next_link=None):
            _request = prepare_request(next_link)

            _stream = False
            pipeline_response: PipelineResponse = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
                _request, stream=_stream, **kwargs
            )
            response = pipeline_response.http_response

            if response.status_code not in [200]:
                if _stream:
                    await response.read()  # Load the body in memory and close the socket
                map_error(status_code=response.status_code, response=response, error_map=error_map)
                raise HttpResponseError(response=response)

            return pipeline_response

        return AsyncItemPaged(get_next, extract_data)

    @overload
    async def remove_blocklist_items(  # pylint: disable=inconsistent-return-statements
        self,
        blocklist_name: str,
        options: _models.RemoveTextBlocklistItemsOptions,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> None:
        """Remove BlocklistItems From Text Blocklist.

        Remove blocklistItems from a text blocklist. You can remove at most 100 BlocklistItems in one
        request.

        :param blocklist_name: Text blocklist name. Required.
        :type blocklist_name: str
        :param options: Options for removing blocklist items. Required.
        :type options: ~azure.ai.contentsafety.models.RemoveTextBlocklistItemsOptions
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: None
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def remove_blocklist_items(  # pylint: disable=inconsistent-return-statements
        self, blocklist_name: str, options: JSON, *, content_type: str = "application/json", **kwargs: Any
    ) -> None:
        """Remove BlocklistItems From Text Blocklist.

        Remove blocklistItems from a text blocklist. You can remove at most 100 BlocklistItems in one
        request.

        :param blocklist_name: Text blocklist name. Required.
        :type blocklist_name: str
        :param options: Options for removing blocklist items. Required.
        :type options: JSON
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: None
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def remove_blocklist_items(  # pylint: disable=inconsistent-return-statements
        self, blocklist_name: str, options: IO[bytes], *, content_type: str = "application/json", **kwargs: Any
    ) -> None:
        """Remove BlocklistItems From Text Blocklist.

        Remove blocklistItems from a text blocklist. You can remove at most 100 BlocklistItems in one
        request.

        :param blocklist_name: Text blocklist name. Required.
        :type blocklist_name: str
        :param options: Options for removing blocklist items. Required.
        :type options: IO[bytes]
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: None
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace_async
    async def remove_blocklist_items(  # pylint: disable=inconsistent-return-statements
        self,
        blocklist_name: str,
        options: Union[_models.RemoveTextBlocklistItemsOptions, JSON, IO[bytes]],
        **kwargs: Any
    ) -> None:
        """Remove BlocklistItems From Text Blocklist.

        Remove blocklistItems from a text blocklist. You can remove at most 100 BlocklistItems in one
        request.

        :param blocklist_name: Text blocklist name. Required.
        :type blocklist_name: str
        :param options: Options for removing blocklist items. Is one of the following types:
         RemoveTextBlocklistItemsOptions, JSON, IO[bytes] Required.
        :type options: ~azure.ai.contentsafety.models.RemoveTextBlocklistItemsOptions or JSON or
         IO[bytes]
        :keyword content_type: Body parameter Content-Type. Known values are: application/json. Default
         value is None.
        :paramtype content_type: str
        :return: None
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[None] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _content = None
        if isinstance(options, (IOBase, bytes)):
            _content = options
        else:
            _content = json.dumps(options, cls=SdkJSONEncoder, exclude_readonly=True)  # type: ignore

        _request = build_blocklist_remove_blocklist_items_request(
            blocklist_name=blocklist_name,
            content_type=content_type,
            api_version=self._config.api_version,
            content=_content,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [204]:
            if _stream:
                await response.read()  # Load the body in memory and close the socket
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if cls:
            return cls(pipeline_response, None, {})  # type: ignore
